/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.listeners;

import com.gmail.nossr50.config.WorldBlacklist;
import com.gmail.nossr50.mcMMO;
import org.bukkit.Chunk;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldListener
implements Listener {
    private final mcMMO plugin;

    public WorldListener(mcMMO plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getWorld())) {
            return;
        }
        this.plugin.getFoliaLib().getScheduler().runLater(() -> {
            for (BlockState blockState : event.getBlocks()) {
                mcMMO.getUserBlockTracker().setEligible(blockState);
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getWorld())) {
            return;
        }
        mcMMO.getChunkManager().unloadWorld(event.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (WorldBlacklist.isWorldBlacklisted(event.getWorld())) {
            return;
        }
        Chunk chunk = event.getChunk();
        mcMMO.getChunkManager().chunkUnloaded(chunk.getX(), chunk.getZ(), event.getWorld());
    }
}

