/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.text;

import com.gmail.nossr50.mcMMO;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextUtils {
    @Nullable
    private static LegacyComponentSerializer customLegacySerializer;

    private TextUtils() {
    }

    @NotNull
    static Component fromArray(@NotNull Component[] componentsArray, @Nullable Component prefixComponent, @Nullable Component suffixComponent) {
        TextComponent.Builder componentBuilder = Component.text();
        for (Component component : componentsArray) {
            if (component == null) continue;
            if (prefixComponent != null) {
                componentBuilder.append(prefixComponent);
            }
            componentBuilder.append(component);
            if (suffixComponent == null) continue;
            componentBuilder.append(suffixComponent);
        }
        return componentBuilder.build();
    }

    @NotNull
    static Component[][] splitComponentsIntoGroups(@NotNull List<Component> components, int groupsSize) {
        int groupCount = (int)Math.ceil((double)components.size() / (double)groupsSize);
        Component[][] splitGroups = new Component[groupCount][groupsSize];
        for (int groupsFinished = 0; groupsFinished < groupCount; ++groupsFinished) {
            int indexOfPotentialMember;
            for (int i = 0; i < groupsSize && (indexOfPotentialMember = i + groupsFinished * 3) <= components.size() - 1; ++i) {
                Component potentialMember = components.get(indexOfPotentialMember);
                if (potentialMember == null) continue;
                splitGroups[groupsFinished][i] = potentialMember;
            }
        }
        return splitGroups;
    }

    static void addChildWebComponent(@NotNull ComponentBuilder<?, ?> webTextComponent, @NotNull String childName) {
        TextComponent childComponent = (TextComponent)Component.text((String)childName).color((TextColor)NamedTextColor.BLUE);
        webTextComponent.append((Component)childComponent);
    }

    static void addNewHoverComponentToTextComponent(@NotNull TextComponent.Builder textComponent, @NotNull Component baseComponent) {
        textComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)baseComponent));
    }

    public static BaseComponent[] convertToBungeeComponent(@NotNull String displayName) {
        return net.md_5.bungee.api.chat.TextComponent.fromLegacyText((String)displayName);
    }

    @NotNull
    public static TextComponent ofBungeeComponents(@NotNull BaseComponent[] bungeeName) {
        return Component.textOfChildren((ComponentLike[])new ComponentLike[]{mcMMO.getCompatibilityManager().getBungeeSerializerCompatibilityLayer().deserialize(bungeeName)});
    }

    @NotNull
    public static TextComponent ofBungeeRawStrings(@NotNull String bungeeRawString) {
        return TextUtils.ofBungeeComponents(TextUtils.convertToBungeeComponent(bungeeRawString));
    }

    @NotNull
    public static TextComponent ofLegacyTextRaw(@NotNull String rawString) {
        return LegacyComponentSerializer.legacySection().deserialize(rawString);
    }

    @NotNull
    public static TextComponent colorizeText(@NotNull String rawtext) {
        if (customLegacySerializer == null) {
            customLegacySerializer = TextUtils.getSerializer();
        }
        return customLegacySerializer.deserialize(rawtext);
    }

    @NotNull
    private static LegacyComponentSerializer getSerializer() {
        return LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().character('&').hexCharacter('#').extractUrls(Style.style().decorate(TextUtils.getURLStyle()).color((TextColor)NamedTextColor.DARK_AQUA).build()).build();
    }

    @NotNull
    public static TextDecoration[] getURLStyle() {
        return new TextDecoration[]{TextDecoration.UNDERLINED};
    }

    @NotNull
    public static String sanitizeForSerializer(@NotNull String string) {
        if (customLegacySerializer == null) {
            customLegacySerializer = TextUtils.getSerializer();
        }
        TextComponent componentForm = TextUtils.ofLegacyTextRaw(string);
        return customLegacySerializer.serialize((Component)componentForm);
    }
}

