/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.subskills.taming;

import com.gmail.nossr50.datatypes.skills.subskills.taming.CallOfTheWildType;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class TamingSummon {
    private final Material itemType;
    private final int itemAmountRequired;
    private final int entitiesSummoned;
    private final int summonLifespan;
    private final int summonCap;
    private final CallOfTheWildType callOfTheWildType;
    private EntityType entityType;

    public TamingSummon(CallOfTheWildType callOfTheWildType, Material itemType, int itemAmountRequired, int entitiesSummoned, int summonLifespan, int summonCap) {
        this.callOfTheWildType = callOfTheWildType;
        this.itemType = itemType;
        this.itemAmountRequired = Math.max(itemAmountRequired, 1);
        this.entitiesSummoned = Math.max(entitiesSummoned, 1);
        this.summonLifespan = summonLifespan;
        this.summonCap = Math.max(summonCap, 1);
        this.initEntityType();
    }

    private void initEntityType() {
        switch (this.callOfTheWildType) {
            case WOLF: {
                this.entityType = EntityType.WOLF;
                break;
            }
            case HORSE: {
                this.entityType = EntityType.HORSE;
                break;
            }
            case CAT: {
                this.entityType = this.shouldSpawnCatInsteadOfOcelot() ? EntityType.CAT : EntityType.OCELOT;
            }
        }
    }

    private boolean shouldSpawnCatInsteadOfOcelot() {
        try {
            Class<?> clazz = Class.forName("org.bukkit.entity.Panda");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Material getItemType() {
        return this.itemType;
    }

    public int getItemAmountRequired() {
        return this.itemAmountRequired;
    }

    public int getEntitiesSummoned() {
        return this.entitiesSummoned;
    }

    public int getSummonLifespan() {
        return this.summonLifespan;
    }

    public int getSummonCap() {
        return this.summonCap;
    }

    public CallOfTheWildType getCallOfTheWildType() {
        return this.callOfTheWildType;
    }
}

