/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.treasure;

import com.gmail.nossr50.util.random.Probability;
import com.google.common.base.Objects;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class Treasure {
    private int xp;
    private double dropChance;
    @NotNull
    private Probability dropProbability;
    private int dropLevel;
    @NotNull
    private ItemStack drop;

    public Treasure(ItemStack drop, int xp, double dropChance, int dropLevel) {
        this.drop = drop;
        this.xp = xp;
        this.dropChance = dropChance;
        this.dropProbability = Probability.ofPercent(dropChance);
        this.dropLevel = dropLevel;
    }

    @NotNull
    public Probability getDropProbability() {
        return this.dropProbability;
    }

    @NotNull
    public ItemStack getDrop() {
        return this.drop;
    }

    public void setDrop(@NotNull ItemStack drop) {
        this.drop = drop;
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public double getDropChance() {
        return this.dropChance;
    }

    public void setDropChance(double dropChance) {
        this.dropChance = dropChance;
        this.dropProbability = Probability.ofPercent(dropChance);
    }

    public int getDropLevel() {
        return this.dropLevel;
    }

    public void setDropLevel(int dropLevel) {
        this.dropLevel = dropLevel;
    }

    public String toString() {
        return "Treasure{xp=" + this.xp + ", dropChance=" + this.dropChance + ", dropProbability=" + String.valueOf(this.dropProbability) + ", dropLevel=" + this.dropLevel + ", drop=" + String.valueOf(this.drop) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Treasure treasure = (Treasure)o;
        return this.xp == treasure.xp && Double.compare(treasure.dropChance, this.dropChance) == 0 && this.dropLevel == treasure.dropLevel && Objects.equal((Object)this.dropProbability, (Object)treasure.dropProbability) && Objects.equal((Object)this.drop, (Object)treasure.drop);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.xp, this.dropChance, this.dropProbability, this.dropLevel, this.drop});
    }
}

