/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.experience;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class FormulaManager {
    private static final File formulaFile = new File(mcMMO.getFlatFileDirectory() + "formula.yml");
    private Map<Integer, Integer> experienceNeededRetroLinear;
    private Map<Integer, Integer> experienceNeededStandardLinear;
    private Map<Integer, Integer> experienceNeededRetroExponential;
    private Map<Integer, Integer> experienceNeededStandardExponential;
    private FormulaType previousFormula;

    public FormulaManager() {
        this.initExperienceNeededMaps();
        this.loadFormula();
    }

    private void initExperienceNeededMaps() {
        this.experienceNeededRetroLinear = new HashMap<Integer, Integer>();
        this.experienceNeededRetroExponential = new HashMap<Integer, Integer>();
        this.experienceNeededStandardLinear = new HashMap<Integer, Integer>();
        this.experienceNeededStandardExponential = new HashMap<Integer, Integer>();
    }

    public FormulaType getPreviousFormulaType() {
        return this.previousFormula;
    }

    public void setPreviousFormulaType(FormulaType previousFormulaType) {
        this.previousFormula = previousFormulaType;
    }

    public int calculateTotalExperience(int skillLevel, int skillXPLevel) {
        int totalXP = 0;
        for (int level = 0; level < skillLevel; ++level) {
            totalXP += this.getXPtoNextLevel(level, this.previousFormula);
        }
        return totalXP += skillXPLevel;
    }

    public int[] calculateNewLevel(PrimarySkillType primarySkillType, int experience, FormulaType formulaType) {
        int experienceToNextLevel;
        int newLevel;
        int remainder = 0;
        int maxLevel = mcMMO.p.getSkillTools().getLevelCap(primarySkillType);
        for (newLevel = 0; experience > 0 && newLevel < maxLevel; ++newLevel, experience -= experienceToNextLevel) {
            experienceToNextLevel = this.getXPtoNextLevel(newLevel, formulaType);
            if (experience - experienceToNextLevel >= 0) continue;
            remainder = experience;
            break;
        }
        return new int[]{newLevel, remainder};
    }

    public int getXPtoNextLevel(int level, FormulaType formulaType) {
        if (formulaType == FormulaType.UNKNOWN) {
            formulaType = FormulaType.LINEAR;
        }
        return this.processXPToNextLevel(level, formulaType);
    }

    private int processXPToNextLevel(int level, FormulaType formulaType) {
        if (mcMMO.isRetroModeEnabled()) {
            return this.processXPRetroToNextLevel(level, formulaType);
        }
        return this.processStandardXPToNextLevel(level, formulaType);
    }

    private int processStandardXPToNextLevel(int level, FormulaType formulaType) {
        Map<Integer, Integer> experienceMapRef;
        Map<Integer, Integer> map = experienceMapRef = formulaType == FormulaType.LINEAR ? this.experienceNeededStandardLinear : this.experienceNeededStandardExponential;
        if (!experienceMapRef.containsKey(level)) {
            int retroIndex;
            int experienceSum = 0;
            for (int x = retroIndex = level * 10 + 1; x < retroIndex + 10; ++x) {
                experienceSum += this.calculateXPNeeded(x, formulaType);
            }
            experienceMapRef.put(level, experienceSum);
        }
        return experienceMapRef.get(level);
    }

    private int processXPRetroToNextLevel(int level, FormulaType formulaType) {
        Map<Integer, Integer> experienceMapRef;
        Map<Integer, Integer> map = experienceMapRef = formulaType == FormulaType.LINEAR ? this.experienceNeededRetroLinear : this.experienceNeededRetroExponential;
        if (!experienceMapRef.containsKey(level)) {
            int experience = this.calculateXPNeeded(level, formulaType);
            experienceMapRef.put(level, experience);
        }
        return experienceMapRef.get(level);
    }

    private int calculateXPNeeded(int level, FormulaType formulaType) {
        int base = ExperienceConfig.getInstance().getBase(formulaType);
        double multiplier = ExperienceConfig.getInstance().getMultiplier(formulaType);
        switch (formulaType) {
            case LINEAR: {
                return (int)Math.floor((double)base + (double)level * multiplier);
            }
            case EXPONENTIAL: {
                double exponent = ExperienceConfig.getInstance().getExponent(formulaType);
                return (int)Math.floor(multiplier * Math.pow(level, exponent) + (double)base);
            }
        }
        mcMMO.p.getLogger().severe("Invalid formula specified for calculation, defaulting to Linear");
        return this.calculateXPNeeded(level, FormulaType.LINEAR);
    }

    public void loadFormula() {
        if (!formulaFile.exists()) {
            this.previousFormula = FormulaType.UNKNOWN;
            return;
        }
        this.previousFormula = FormulaType.getFormulaType(YamlConfiguration.loadConfiguration((File)formulaFile).getString("Previous_Formula", "UNKNOWN"));
    }

    public void saveFormula() {
        LogUtils.debug(mcMMO.p.getLogger(), "Saving previous XP formula type...");
        YamlConfiguration formulasFile = new YamlConfiguration();
        formulasFile.set("Previous_Formula", (Object)this.previousFormula.toString());
        try {
            formulasFile.save(formulaFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

