/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.text;

import com.gmail.nossr50.config.RankConfig;
import com.gmail.nossr50.datatypes.json.McMMOWebLinks;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.text.StringUtils;
import com.gmail.nossr50.util.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class TextComponentFactory {
    public static TextComponent getNotificationMultipleValues(String localeKey, String ... values) {
        String preColoredString = LocaleLoader.getString(localeKey, values);
        return Component.text((String)preColoredString);
    }

    public static Component getNotificationTextComponentFromLocale(String localeKey) {
        return TextComponentFactory.getNotificationTextComponent(LocaleLoader.getString(localeKey));
    }

    public static Component getNotificationLevelUpTextComponent(PrimarySkillType skill, int levelsGained, int currentLevel) {
        return Component.text((String)LocaleLoader.getString("Overhaul.Levelup", LocaleLoader.getString("Overhaul.Name." + StringUtils.getCapitalized(skill.toString())), levelsGained, currentLevel));
    }

    private static TextComponent getNotificationTextComponent(String text) {
        return Component.text((String)text);
    }

    public static String getSubSkillWikiLink(SubSkillType subSkillType) {
        return "https://wiki.mcmmo.org/en/skills/" + subSkillType.getParentSkill().toString().toLowerCase(Locale.ENGLISH) + "#" + subSkillType.getWikiUrl().toLowerCase(Locale.ENGLISH);
    }

    public static void sendPlayerSubSkillWikiLink(Player player, String subskillformatted, SubSkillType subSkillType) {
        if (!mcMMO.p.getGeneralConfig().getUrlLinksEnabled()) {
            return;
        }
        TextComponent.Builder wikiLinkComponent = Component.text().content(LocaleLoader.getString("Overhaul.mcMMO.MmoInfo.Wiki"));
        wikiLinkComponent.decoration(TextDecoration.UNDERLINED, true);
        String subSkillWikiLink = TextComponentFactory.getSubSkillWikiLink(subSkillType);
        wikiLinkComponent.clickEvent(ClickEvent.openUrl((String)subSkillWikiLink));
        TextComponent.Builder componentBuilder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(subskillformatted).append((Component)Component.newline())).append((Component)Component.text((String)subSkillWikiLink))).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, true);
        wikiLinkComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)componentBuilder.build()));
        mcMMO.getAudiences().player(player).sendMessage((ComponentLike)wikiLinkComponent);
    }

    public static void sendPlayerUrlHeader(Player player) {
        TextComponent prefix = Component.text((String)(LocaleLoader.getString("Overhaul.mcMMO.Url.Wrap.Prefix") + " "));
        TextComponent suffix = Component.text((String)(" " + LocaleLoader.getString("Overhaul.mcMMO.Url.Wrap.Suffix")));
        TextComponent emptySpace = Component.space();
        mcMMO.getAudiences().player(player).sendMessage((Component)Component.textOfChildren((ComponentLike[])new ComponentLike[]{prefix, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.WEBSITE), emptySpace, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.DISCORD), emptySpace, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.PATREON), emptySpace, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.WIKI), emptySpace, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.SPIGOT), emptySpace, TextComponentFactory.getWebLinkTextComponent(McMMOWebLinks.HELP_TRANSLATE), suffix}));
    }

    public static void sendPlayerSubSkillList(@NotNull Player player, @NotNull List<Component> subSkillComponents) {
        Audience audience = mcMMO.getAudiences().player(player);
        TextComponent space = Component.space();
        TextComponent atSignComponent = Component.text((String)LocaleLoader.getString("JSON.Hover.AtSymbolSkills"));
        Component[][] splitSubSkills = TextUtils.splitComponentsIntoGroups(subSkillComponents, 3);
        ArrayList<Component> individualLinesToSend = new ArrayList<Component>();
        for (Component[] componentArray : splitSubSkills) {
            individualLinesToSend.add(TextUtils.fromArray(componentArray, (Component)atSignComponent, (Component)space));
        }
        for (Component curLine : individualLinesToSend) {
            audience.sendMessage(curLine);
        }
    }

    private static Component getWebLinkTextComponent(McMMOWebLinks webLinks) {
        TextComponent.Builder webTextComponent;
        switch (webLinks) {
            case WEBSITE: {
                webTextComponent = Component.text().content(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextUtils.addChildWebComponent(webTextComponent, "Web");
                webTextComponent.clickEvent(TextComponentFactory.getUrlClickEvent("https://www.mcmmo.org"));
                break;
            }
            case SPIGOT: {
                webTextComponent = Component.text().content(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextUtils.addChildWebComponent(webTextComponent, "Spigot");
                webTextComponent.clickEvent(TextComponentFactory.getUrlClickEvent("https://spigot.mcmmo.org"));
                break;
            }
            case DISCORD: {
                webTextComponent = Component.text().content(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextUtils.addChildWebComponent(webTextComponent, "Discord");
                webTextComponent.clickEvent(TextComponentFactory.getUrlClickEvent("https://discord.gg/bJ7pFS9"));
                break;
            }
            case PATREON: {
                webTextComponent = Component.text().content(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextUtils.addChildWebComponent(webTextComponent, "Patreon");
                webTextComponent.clickEvent(TextComponentFactory.getUrlClickEvent("https://www.patreon.com/nossr50"));
                break;
            }
            case WIKI: {
                webTextComponent = Component.text().content(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextUtils.addChildWebComponent(webTextComponent, "Wiki");
                webTextComponent.clickEvent(TextComponentFactory.getUrlClickEvent("https://wiki.mcmmo.org/"));
                break;
            }
            case HELP_TRANSLATE: {
                webTextComponent = Component.text().content(LocaleLoader.getString("JSON.Hover.AtSymbolURL"));
                TextUtils.addChildWebComponent(webTextComponent, "Lang");
                webTextComponent.clickEvent(TextComponentFactory.getUrlClickEvent("https://translate.mcmmo.org/"));
                break;
            }
            default: {
                webTextComponent = Component.text().content("NOT DEFINED");
            }
        }
        TextUtils.addNewHoverComponentToTextComponent(webTextComponent, TextComponentFactory.getUrlHoverEvent(webLinks));
        webTextComponent.insertion(webLinks.getUrl());
        return webTextComponent.build();
    }

    private static Component getUrlHoverEvent(McMMOWebLinks webLinks) {
        TextComponent.Builder componentBuilder = Component.text().content(webLinks.getNiceTitle());
        switch (webLinks) {
            case WEBSITE: {
                TextComponentFactory.addUrlHeaderHover(webLinks, componentBuilder);
                ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)webLinks.getLocaleDescription(), (TextColor)NamedTextColor.GREEN));
                componentBuilder.append((Component)Component.text((String)"\nDev Blogs, and information related to mcMMO can be found here", (TextColor)NamedTextColor.GRAY));
                break;
            }
            case SPIGOT: {
                TextComponentFactory.addUrlHeaderHover(webLinks, componentBuilder);
                ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)webLinks.getLocaleDescription(), (TextColor)NamedTextColor.GREEN));
                componentBuilder.append((Component)Component.text((String)"\nI post regularly in the discussion thread here!", (TextColor)NamedTextColor.GRAY));
                break;
            }
            case PATREON: {
                TextComponentFactory.addUrlHeaderHover(webLinks, componentBuilder);
                ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)webLinks.getLocaleDescription(), (TextColor)NamedTextColor.GREEN));
                componentBuilder.append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)"Show support by buying me a coffee :)", (TextColor)NamedTextColor.GRAY));
                break;
            }
            case WIKI: {
                TextComponentFactory.addUrlHeaderHover(webLinks, componentBuilder);
                ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)webLinks.getLocaleDescription(), (TextColor)NamedTextColor.GREEN));
                componentBuilder.append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)"I'm looking for more wiki staff, contact me on our discord!", (TextColor)NamedTextColor.DARK_GRAY));
                break;
            }
            case DISCORD: {
                TextComponentFactory.addUrlHeaderHover(webLinks, componentBuilder);
                ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)webLinks.getLocaleDescription(), (TextColor)NamedTextColor.GREEN));
                break;
            }
            case HELP_TRANSLATE: {
                TextComponentFactory.addUrlHeaderHover(webLinks, componentBuilder);
                ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)webLinks.getLocaleDescription(), (TextColor)NamedTextColor.GREEN));
                componentBuilder.append((Component)Component.newline());
                componentBuilder.append((Component)Component.text((String)"You can use this website to help translate mcMMO into your language!\nIf you want to know more contact me in discord.", (TextColor)NamedTextColor.DARK_GRAY));
            }
        }
        return componentBuilder.build();
    }

    private static void addUrlHeaderHover(McMMOWebLinks webLinks, TextComponent.Builder componentBuilder) {
        componentBuilder.append((Component)Component.newline());
        componentBuilder.append((Component)Component.text((String)webLinks.getUrl(), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
    }

    private static ClickEvent getUrlClickEvent(String url) {
        return ClickEvent.openUrl((String)url);
    }

    private static Component getSubSkillTextComponent(Player player, SubSkillType subSkillType) {
        String skillName = ChatColor.stripColor((String)subSkillType.getLocaleName());
        boolean skillUnlocked = RankUtils.hasUnlockedSubskill(player, subSkillType);
        TextComponent.Builder textComponent = TextComponentFactory.initNewSkillTextComponent(player, skillName, subSkillType, skillUnlocked);
        TextUtils.addNewHoverComponentToTextComponent(textComponent, TextComponentFactory.getSubSkillHoverComponent(player, subSkillType));
        textComponent.insertion(skillName);
        return textComponent.build();
    }

    private static TextComponent getSubSkillTextComponent(Player player, AbstractSubSkill abstractSubSkill) {
        String skillName = abstractSubSkill.getNiceName();
        SubSkillType subSkillType = abstractSubSkill.getSubSkillType();
        boolean skillUnlocked = RankUtils.hasUnlockedSubskill(player, subSkillType);
        TextComponent.Builder textComponent = TextComponentFactory.initNewSkillTextComponent(player, skillName, subSkillType, skillUnlocked);
        TextUtils.addNewHoverComponentToTextComponent(textComponent, TextComponentFactory.getSubSkillHoverComponent(player, abstractSubSkill));
        textComponent.insertion(skillName);
        return (TextComponent)textComponent.build();
    }

    private static TextComponent.Builder initNewSkillTextComponent(Player player, String skillName, SubSkillType subSkillType, boolean skillUnlocked) {
        TextComponent.Builder textComponent;
        if (skillUnlocked) {
            textComponent = RankUtils.getHighestRank(subSkillType) == RankUtils.getRank(player, subSkillType) && subSkillType.getNumRanks() > 1 ? Component.text().content(LocaleLoader.getString("JSON.Hover.MaxRankSkillName", skillName)) : Component.text().content(LocaleLoader.getString("JSON.Hover.SkillName", skillName));
            textComponent.clickEvent(ClickEvent.runCommand((String)("/mmoinfo " + subSkillType.getNiceNameNoSpaces(subSkillType))));
        } else {
            textComponent = Component.text().content(LocaleLoader.getString("JSON.Hover.Mystery", String.valueOf(RankUtils.getUnlockLevel(subSkillType))));
            textComponent.clickEvent(ClickEvent.runCommand((String)"/mmoinfo ???"));
        }
        return textComponent;
    }

    private static Component getSubSkillHoverComponent(Player player, AbstractSubSkill abstractSubSkill) {
        return TextComponentFactory.getSubSkillHoverEventJSON(abstractSubSkill, player);
    }

    private static Component getSubSkillHoverComponent(Player player, SubSkillType subSkillType) {
        return TextComponentFactory.getSubSkillHoverEventJSON(subSkillType, player);
    }

    private static Component getSubSkillHoverEventJSON(AbstractSubSkill abstractSubSkill, Player player) {
        String skillName = ChatColor.stripColor((String)abstractSubSkill.getNiceName());
        NamedTextColor ccLocked = NamedTextColor.DARK_GRAY;
        NamedTextColor ccLevelRequirement = NamedTextColor.BLUE;
        NamedTextColor ccLevelRequired = NamedTextColor.RED;
        SubSkillType subSkillType = abstractSubSkill.getSubSkillType();
        TextComponent.Builder componentBuilder = TextComponentFactory.setupSkillComponentNameStyle(player, skillName, subSkillType, RankUtils.hasUnlockedSubskill(player, abstractSubSkill));
        if (!RankUtils.hasUnlockedSubskill(player, abstractSubSkill)) {
            TextComponentFactory.addLocked(abstractSubSkill, (TextColor)ccLocked, (TextColor)ccLevelRequirement, (TextColor)ccLevelRequired, componentBuilder);
        } else {
            TextComponentFactory.addSubSkillTypeToHoverEventJSON(abstractSubSkill, componentBuilder);
            int curRank = RankUtils.getRank(player, abstractSubSkill);
            int nextRank = 0;
            if (curRank < abstractSubSkill.getNumRanks() && abstractSubSkill.getNumRanks() > 0) {
                nextRank = RankUtils.getRankUnlockLevel(abstractSubSkill, curRank + 1);
            }
            TextComponentFactory.addRanked(componentBuilder, abstractSubSkill.getNumRanks(), RankUtils.getRank(player, abstractSubSkill), nextRank);
            componentBuilder.append((Component)Component.text((String)LocaleLoader.getString("JSON.DescriptionHeader")));
            ((TextComponent.Builder)((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.text((String)abstractSubSkill.getDescription()))).append((Component)Component.newline());
            ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).decoration(TextDecoration.BOLD, false);
            componentBuilder.append((Component)Component.newline());
            abstractSubSkill.addStats(componentBuilder, UserManager.getPlayer(player));
        }
        return componentBuilder.build();
    }

    private static TextComponent.Builder setupSkillComponentNameStyle(Player player, String skillName, SubSkillType subSkillType, boolean skillUnlocked) {
        TextComponent.Builder componentBuilder = skillUnlocked ? (RankUtils.getHighestRank(subSkillType) == RankUtils.getRank(player, subSkillType) && subSkillType.getNumRanks() > 1 ? TextComponentFactory.getNewComponentBuilder(LocaleLoader.getString("JSON.Hover.MaxRankSkillName", skillName)) : TextComponentFactory.getNewComponentBuilder(LocaleLoader.getString("JSON.Hover.SkillName", skillName))) : TextComponentFactory.getNewComponentBuilder(LocaleLoader.getString("JSON.Hover.Mystery", String.valueOf(RankUtils.getUnlockLevel(subSkillType))));
        return componentBuilder;
    }

    private static TextComponent.Builder getNewComponentBuilder(String skillName) {
        TextComponent.Builder componentBuilder = Component.text().content(skillName);
        componentBuilder.append((Component)Component.newline());
        return componentBuilder;
    }

    private static void addRanked(TextComponent.Builder componentBuilder, int numRanks, int rank, int nextRank) {
        if (numRanks > 0) {
            ((TextComponent.Builder)componentBuilder.append((Component)Component.text((String)LocaleLoader.getString("JSON.Hover.Rank", String.valueOf(rank))))).append((Component)Component.newline());
            if (nextRank > rank) {
                ((TextComponent.Builder)componentBuilder.append((Component)Component.text((String)LocaleLoader.getString("JSON.Hover.NextRank", String.valueOf(nextRank))))).append((Component)Component.newline());
            }
        }
    }

    private static void addLocked(SubSkillType subSkillType, TextColor ccLocked, TextColor ccLevelRequirement, TextColor ccLevelRequired, TextComponent.Builder componentBuilder) {
        TextComponentFactory.addLocked(ccLocked, ccLevelRequirement, componentBuilder);
        componentBuilder.append((Component)Component.text((String)String.valueOf(RankConfig.getInstance().getSubSkillUnlockLevel(subSkillType, 1)), (TextColor)ccLevelRequired));
    }

    private static void addLocked(AbstractSubSkill abstractSubSkill, TextColor ccLocked, TextColor ccLevelRequirement, TextColor ccLevelRequired, TextComponent.Builder componentBuilder) {
        TextComponentFactory.addLocked(ccLocked, ccLevelRequirement, componentBuilder);
        componentBuilder.append((Component)Component.text((String)String.valueOf(RankConfig.getInstance().getSubSkillUnlockLevel(abstractSubSkill, 1)), (TextColor)ccLevelRequired));
    }

    private static void addLocked(TextColor ccLocked, TextColor ccLevelRequirement, TextComponent.Builder componentBuilder) {
        componentBuilder.append((Component)Component.text((String)LocaleLoader.getString("JSON.Locked"), (TextColor)ccLocked, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        ((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.newline());
        componentBuilder.append((Component)Component.text((String)(LocaleLoader.getString("JSON.LevelRequirement") + ": "), (TextColor)ccLevelRequirement));
    }

    private static Component getSubSkillHoverEventJSON(SubSkillType subSkillType, Player player) {
        String skillName = ChatColor.stripColor((String)subSkillType.getLocaleName());
        NamedTextColor ccDescriptionHeader = NamedTextColor.DARK_PURPLE;
        NamedTextColor ccDescription = NamedTextColor.DARK_GRAY;
        NamedTextColor ccLocked = NamedTextColor.DARK_GRAY;
        NamedTextColor ccLevelRequirement = NamedTextColor.BLUE;
        NamedTextColor ccLevelRequired = NamedTextColor.RED;
        TextComponent.Builder componentBuilder = TextComponentFactory.setupSkillComponentNameStyle(player, skillName, subSkillType, RankUtils.hasUnlockedSubskill(player, subSkillType));
        if (!RankUtils.hasUnlockedSubskill(player, subSkillType)) {
            TextComponentFactory.addLocked(subSkillType, (TextColor)ccLocked, (TextColor)ccLevelRequirement, (TextColor)ccLevelRequired, componentBuilder);
        } else {
            if (subSkillType.getNumRanks() > 0) {
                int curRank = RankUtils.getRank(player, subSkillType);
                int nextRank = 0;
                if (curRank < subSkillType.getNumRanks()) {
                    nextRank = RankUtils.getRankUnlockLevel(subSkillType, curRank + 1);
                }
                TextComponentFactory.addRanked(componentBuilder, subSkillType.getNumRanks(), RankUtils.getRank(player, subSkillType), nextRank);
            }
            componentBuilder.append((Component)Component.newline());
            componentBuilder.append(Component.text((String)LocaleLoader.getString("JSON.DescriptionHeader")).color((TextColor)ccDescriptionHeader));
            componentBuilder.append((Component)Component.newline());
            componentBuilder.append(Component.text((String)ChatColor.stripColor((String)subSkillType.getLocaleDescription())).color((TextColor)ccDescription));
        }
        return componentBuilder.build();
    }

    private static void addSubSkillTypeToHoverEventJSON(AbstractSubSkill abstractSubSkill, TextComponent.Builder componentBuilder) {
        if (abstractSubSkill.isSuperAbility()) {
            componentBuilder.append((Component)Component.text((String)LocaleLoader.getString("JSON.Type.SuperAbility"), (TextColor)NamedTextColor.LIGHT_PURPLE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        } else if (abstractSubSkill.isActiveUse()) {
            componentBuilder.append((Component)Component.text((String)LocaleLoader.getString("JSON.Type.Active"), (TextColor)NamedTextColor.DARK_RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        } else {
            componentBuilder.append((Component)Component.text((String)LocaleLoader.getString("JSON.Type.Passive"), (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
        }
        componentBuilder.append((Component)Component.newline());
    }

    public static void getSubSkillTextComponents(Player player, List<Component> textComponents, PrimarySkillType parentSkill) {
        for (SubSkillType subSkillType : SubSkillType.values()) {
            if (subSkillType.getParentSkill() != parentSkill || subSkillType == SubSkillType.FISHING_MASTER_ANGLER && mcMMO.getCompatibilityManager().getMasterAnglerCompatibilityLayer() == null || !Permissions.isSubSkillEnabled((Permissible)player, subSkillType) || InteractionManager.hasSubSkill(subSkillType)) continue;
            textComponents.add(TextComponentFactory.getSubSkillTextComponent(player, subSkillType));
        }
        for (AbstractSubSkill abstractSubSkill : InteractionManager.getSubSkillList()) {
            if (abstractSubSkill.getPrimarySkill() != parentSkill || !Permissions.isSubSkillEnabled((Permissible)player, abstractSubSkill.getSubSkillType())) continue;
            textComponents.add((Component)TextComponentFactory.getSubSkillTextComponent(player, abstractSubSkill));
        }
    }

    public static TextComponent getSubSkillUnlockedNotificationComponents(Player player, SubSkillType subSkillType) {
        TextComponent.Builder unlockMessage = Component.text().content(LocaleLoader.getString("JSON.SkillUnlockMessage", subSkillType.getLocaleName(), RankUtils.getRank(player, subSkillType)));
        unlockMessage.hoverEvent((HoverEventSource)HoverEvent.showText((Component)TextComponentFactory.getSubSkillHoverComponent(player, subSkillType)));
        unlockMessage.clickEvent(ClickEvent.runCommand((String)("/" + subSkillType.getParentSkill().toString().toLowerCase(Locale.ENGLISH))));
        return (TextComponent)unlockMessage.build();
    }
}

