/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.experience;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillTools;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ExperienceCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length < 2) {
            return false;
        }
        if (args.length == 2 && !this.isSilent(args) || args.length == 3 && this.isSilent(args)) {
            if (CommandUtils.noConsoleUsage(sender)) {
                return true;
            }
            if (!this.permissionsCheckSelf(sender)) {
                if (command.getPermissionMessage() != null) {
                    sender.sendMessage(command.getPermissionMessage());
                }
                sender.sendMessage("(mcMMO) No permission!");
                return true;
            }
            if (!this.validateArguments(sender, args[0], args[1])) {
                return true;
            }
            PrimarySkillType skill = mcMMO.p.getSkillTools().matchSkill(args[0]);
            if (args[1].equalsIgnoreCase("all")) {
                skill = null;
            }
            if (skill != null && SkillTools.isChildSkill(skill)) {
                sender.sendMessage(LocaleLoader.getString("Commands.Skill.ChildSkill"));
                return true;
            }
            if (UserManager.getPlayer(sender.getName()) == null) {
                sender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                return true;
            }
            this.editValues((Player)sender, UserManager.getPlayer(sender.getName()).getProfile(), skill, Integer.parseInt(args[1]), this.isSilent(args));
            return true;
        }
        if (args.length == 3 && !this.isSilent(args) || args.length == 4 && this.isSilent(args)) {
            if (!this.permissionsCheckOthers(sender)) {
                sender.sendMessage(command.getPermissionMessage());
                return true;
            }
            if (!this.validateArguments(sender, args[1], args[2])) {
                return true;
            }
            PrimarySkillType skill = mcMMO.p.getSkillTools().matchSkill(args[1]);
            if (args[1].equalsIgnoreCase("all")) {
                skill = null;
            }
            if (skill != null && SkillTools.isChildSkill(skill)) {
                sender.sendMessage(LocaleLoader.getString("Commands.Skill.ChildSkill"));
                return true;
            }
            int value = Integer.parseInt(args[2]);
            String playerName = CommandUtils.getMatchedPlayerName(args[0]);
            McMMOPlayer mmoPlayer = UserManager.getOfflinePlayer(playerName);
            if (mmoPlayer == null) {
                PlayerProfile profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName);
                if (CommandUtils.unloadedProfile(sender, profile) && CommandUtils.unloadedProfile(sender, profile = mcMMO.getDatabaseManager().loadPlayerProfile(playerName))) {
                    return true;
                }
                this.editValues(null, profile, skill, value, this.isSilent(args));
            } else {
                this.editValues(mmoPlayer.getPlayer(), mmoPlayer.getProfile(), skill, value, this.isSilent(args));
            }
            ExperienceCommand.handleSenderMessage(sender, playerName, skill);
            return true;
        }
        return false;
    }

    private boolean isSilent(String[] args) {
        int length = args.length;
        if (length == 0) {
            return false;
        }
        return args[length - 1].equalsIgnoreCase("-s");
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        switch (args.length) {
            case 1: {
                List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
                return (List)StringUtil.copyPartialMatches((String)args[0], playerNames, new ArrayList(playerNames.size()));
            }
            case 2: {
                return (List)StringUtil.copyPartialMatches((String)args[1], mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES, new ArrayList(mcMMO.p.getSkillTools().LOCALIZED_SKILL_NAMES.size()));
            }
        }
        return ImmutableList.of();
    }

    protected abstract boolean permissionsCheckSelf(CommandSender var1);

    protected abstract boolean permissionsCheckOthers(CommandSender var1);

    protected abstract void handleCommand(Player var1, PlayerProfile var2, PrimarySkillType var3, int var4);

    protected abstract void handlePlayerMessageAll(Player var1, int var2, boolean var3);

    protected abstract void handlePlayerMessageSkill(Player var1, int var2, PrimarySkillType var3, boolean var4);

    private boolean validateArguments(CommandSender sender, String skillName, String value) {
        return !CommandUtils.isInvalidInteger(sender, value) && (skillName.equalsIgnoreCase("all") || !CommandUtils.isInvalidSkill(sender, skillName));
    }

    protected static void handleSenderMessage(CommandSender sender, String playerName, PrimarySkillType skill) {
        if (skill == null) {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardAll.2", playerName));
        } else {
            sender.sendMessage(LocaleLoader.getString("Commands.addlevels.AwardSkill.2", mcMMO.p.getSkillTools().getLocalizedSkillName(skill), playerName));
        }
    }

    protected void editValues(Player player, PlayerProfile profile, PrimarySkillType skill, int value, boolean isSilent) {
        if (skill == null) {
            for (PrimarySkillType primarySkillType : SkillTools.NON_CHILD_SKILLS) {
                this.handleCommand(player, profile, primarySkillType, value);
            }
            if (player != null) {
                this.handlePlayerMessageAll(player, value, isSilent);
            }
        } else {
            this.handleCommand(player, profile, skill, value);
            if (player != null) {
                this.handlePlayerMessageSkill(player, value, skill, isSilent);
            }
        }
    }
}

