/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BukkitConfig {
    boolean copyDefaults;
    protected final String fileName;
    protected final File configFile;
    protected YamlConfiguration defaultYamlConfig;
    protected YamlConfiguration config;
    @NotNull
    protected final File dataFolder;
    private boolean savedDefaults = false;

    public BukkitConfig(@NotNull String fileName, @NotNull File dataFolder, boolean copyDefaults) {
        LogUtils.debug(mcMMO.p.getLogger(), "Initializing config: " + fileName);
        this.copyDefaults = copyDefaults;
        this.fileName = fileName;
        this.dataFolder = dataFolder;
        this.configFile = new File(dataFolder, fileName);
        this.defaultYamlConfig = this.saveDefaultConfigToDisk();
        this.config = this.initConfig();
        this.updateFile();
        LogUtils.debug(mcMMO.p.getLogger(), "Config initialized: " + fileName);
    }

    public BukkitConfig(@NotNull String fileName, @NotNull File dataFolder) {
        this(fileName, dataFolder, true);
    }

    public BukkitConfig(@NotNull String fileName) {
        this(fileName, mcMMO.p.getDataFolder());
    }

    public BukkitConfig(@NotNull String fileName, boolean copyDefaults) {
        this(fileName, mcMMO.p.getDataFolder(), copyDefaults);
    }

    public void updateFile() {
        try {
            this.config.save(this.configFile);
            if (this.copyDefaults && !this.savedDefaults) {
                this.copyMissingDefaultsFromResource();
                this.savedDefaults = true;
            }
        }
        catch (IOException e) {
            mcMMO.p.getLogger().log(Level.SEVERE, "Unable to save config file: " + this.fileName, e);
        }
    }

    private void copyMissingDefaultsFromResource() {
        boolean updated = false;
        for (String key : this.defaultYamlConfig.getKeys(true)) {
            if (this.config.contains(key)) continue;
            this.config.set(key, this.defaultYamlConfig.get(key));
            updated = true;
        }
        if (updated) {
            this.updateFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    YamlConfiguration saveDefaultConfigToDisk() {
        LogUtils.debug(mcMMO.p.getLogger(), "Copying default config to disk: " + this.fileName + " to defaults/" + this.fileName);
        try (InputStream inputStream = mcMMO.p.getResource(this.fileName);){
            if (inputStream == null) {
                mcMMO.p.getLogger().severe("Unable to copy default config: " + this.fileName);
                YamlConfiguration yamlConfiguration2 = null;
                return yamlConfiguration2;
            }
            File defaultsFolder = new File(this.dataFolder, "defaults");
            if (!defaultsFolder.exists()) {
                defaultsFolder.mkdir();
            }
            File defaultFile = new File(defaultsFolder, this.fileName);
            Path path = defaultFile.toPath();
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
            YamlConfiguration defaultYamlConfig = new YamlConfiguration();
            defaultYamlConfig.load(defaultFile);
            YamlConfiguration yamlConfiguration = defaultYamlConfig;
            return yamlConfiguration;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    YamlConfiguration initConfig() {
        if (!this.configFile.exists()) {
            LogUtils.debug(mcMMO.p.getLogger(), "User config file not found, copying a default config to disk: " + this.fileName);
            mcMMO.p.saveResource(this.fileName, false);
        }
        LogUtils.debug(mcMMO.p.getLogger(), "Loading config from disk: " + this.fileName);
        YamlConfiguration config = new YamlConfiguration();
        config.options().indent(4);
        try {
            config.options().parseComments(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        config.options().copyDefaults(true);
        try {
            config.load(this.configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        return config;
    }

    protected abstract void loadKeys();

    protected boolean validateKeys() {
        return true;
    }

    protected boolean noErrorsInConfig(List<String> issues) {
        for (String issue : issues) {
            mcMMO.p.getLogger().warning(issue);
        }
        return issues.isEmpty();
    }

    protected void validate() {
        if (this.validateKeys()) {
            LogUtils.debug(mcMMO.p.getLogger(), "No errors found in " + this.fileName + "!");
        } else {
            mcMMO.p.getLogger().warning("Errors were found in " + this.fileName + "! mcMMO was disabled!");
            mcMMO.p.getServer().getPluginManager().disablePlugin((Plugin)mcMMO.p);
            mcMMO.p.noErrorsInConfigFiles = false;
        }
    }

    public void backup() {
        LogUtils.debug(mcMMO.p.getLogger(), "You are using an old version of the " + this.fileName + " file.");
        LogUtils.debug(mcMMO.p.getLogger(), "Your old file has been renamed to " + this.fileName + ".old and has been replaced by an updated version.");
        this.configFile.renameTo(new File(this.configFile.getPath() + ".old"));
        if (mcMMO.p.getResource(this.fileName) != null) {
            mcMMO.p.saveResource(this.fileName, true);
        }
        mcMMO.p.getLogger().warning("Reloading " + this.fileName + " with new values...");
        this.initConfig();
        this.loadKeys();
    }

    public File getFile() {
        return this.configFile;
    }
}

