/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database.flatfile;

import com.gmail.nossr50.database.FlatFileDataFlag;
import com.gmail.nossr50.database.flatfile.FlatFileDataContainer;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CategorizedFlatFileData
implements FlatFileDataContainer {
    @NotNull
    private final Set<FlatFileDataFlag> dataFlags;
    @NotNull
    private final String[] splitData;
    private final int uniqueProcessingId;

    public CategorizedFlatFileData(int uniqueProcessingId, @NotNull HashSet<FlatFileDataFlag> dataFlags, @NotNull String[] splitData) {
        this.uniqueProcessingId = uniqueProcessingId;
        this.dataFlags = dataFlags;
        this.splitData = splitData;
    }

    @Override
    @NotNull
    public Set<FlatFileDataFlag> getDataFlags() {
        return this.dataFlags;
    }

    @Override
    @NotNull
    public String[] getSplitData() {
        return this.splitData;
    }

    @Override
    public int getUniqueProcessingId() {
        return this.uniqueProcessingId;
    }

    @Override
    public boolean isHealthyData() {
        return this.dataFlags.size() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategorizedFlatFileData that = (CategorizedFlatFileData)o;
        return this.uniqueProcessingId == that.uniqueProcessingId && Objects.equal(this.dataFlags, that.dataFlags) && Objects.equal((Object)this.splitData, (Object)that.splitData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataFlags, this.splitData, this.uniqueProcessingId});
    }

    public String toString() {
        return "CategorizedFlatFileData{dataFlags=" + String.valueOf(this.dataFlags) + ", stringDataRepresentation='" + String.valueOf(this.splitData) + "', uniqueProcessingId=" + this.uniqueProcessingId + "}";
    }
}

