/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills.subskills.acrobatics;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.acrobatics.AcrobaticsSubSkill;
import com.gmail.nossr50.datatypes.skills.subskills.acrobatics.RollResult;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.TextComponent;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.Probability;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class Roll
extends AcrobaticsSubSkill {
    public static final String GRACEFUL_ROLL_ACTIVATED_LOCALE_STR_KEY = "Acrobatics.Ability.Proc";
    public static final String ROLL_ACTIVATED_LOCALE_KEY = "Acrobatics.Roll.Text";

    public Roll() {
        super("Roll", EventPriority.HIGHEST, SubSkillType.ACROBATICS_ROLL);
    }

    @Override
    public boolean doInteraction(Event event, mcMMO plugin) {
        EntityDamageEvent entityDamageEvent = (EntityDamageEvent)event;
        if (!EventUtils.isRealPlayerDamaged(entityDamageEvent) || !entityDamageEvent.isApplicable(EntityDamageEvent.DamageModifier.MAGIC)) {
            return false;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL) {
            McMMOPlayer mmoPlayer = EventUtils.getMcMMOPlayer(entityDamageEvent.getEntity());
            if (mmoPlayer == null) {
                return false;
            }
            if (this.canRoll(mmoPlayer)) {
                RollResult rollResult = this.rollCheck(mmoPlayer, entityDamageEvent);
                if (rollResult == null) {
                    return false;
                }
                if (rollResult.isRollSuccess()) {
                    entityDamageEvent.setDamage(0.0);
                    entityDamageEvent.setDamage(EntityDamageEvent.DamageModifier.MAGIC, rollResult.getModifiedDamage());
                    if (entityDamageEvent.getFinalDamage() == 0.0) {
                        entityDamageEvent.setCancelled(true);
                    }
                    String key = rollResult.isGraceful() ? GRACEFUL_ROLL_ACTIVATED_LOCALE_STR_KEY : ROLL_ACTIVATED_LOCALE_KEY;
                    NotificationManager.sendPlayerInformation(mmoPlayer.getPlayer(), NotificationType.SUBSKILL_MESSAGE, key);
                    SoundManager.sendCategorizedSound(mmoPlayer.getPlayer(), mmoPlayer.getPlayer().getLocation(), SoundType.ROLL_ACTIVATED, SoundCategory.PLAYERS, 0.5f);
                }
                if (!rollResult.isExploiting() && rollResult.getXpGain() > 0.0f) {
                    SkillUtils.applyXpGain(mmoPlayer, this.getPrimarySkill(), rollResult.getXpGain(), XPGainReason.PVE);
                }
                this.addFallLocation(mmoPlayer);
                return true;
            }
            if (mcMMO.p.getSkillTools().doesPlayerHaveSkillPermission(mmoPlayer.getPlayer(), PrimarySkillType.ACROBATICS)) {
                SkillUtils.applyXpGain(mmoPlayer, this.getPrimarySkill(), this.calculateRollXP(mmoPlayer, ((EntityDamageEvent)event).getFinalDamage(), false), XPGainReason.PVE);
            }
        }
        return false;
    }

    @Override
    public String getPermissionNode() {
        return ("mcmmo.ability." + this.getPrimaryKeyName() + "." + this.getConfigKeyName()).toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean hasPermission(Player player) {
        return Permissions.isSubSkillEnabled((Permissible)player, this.getSubSkillType());
    }

    @Override
    public void addStats(TextComponent.Builder componentBuilder, McMMOPlayer mmoPlayer) {
        float skillValue = mmoPlayer.getSkillLevel(this.getPrimarySkill());
        boolean isLucky = Permissions.lucky((Permissible)mmoPlayer.getPlayer(), this.getPrimarySkill());
        String[] rollStrings = ProbabilityUtil.getRNGDisplayValues(mmoPlayer, SubSkillType.ACROBATICS_ROLL);
        String rollChance = rollStrings[0];
        String rollChanceLucky = rollStrings[1];
        Probability probability = this.getRollProbability(mmoPlayer);
        Probability gracefulProbability = Probability.ofValue(probability.getValue() * 2.0);
        String[] gracefulRollStrings = ProbabilityUtil.getRNGDisplayValues(gracefulProbability);
        String gracefulRollChance = gracefulRollStrings[0];
        String gracefulRollChanceLucky = gracefulRollStrings[1];
        componentBuilder.append((Component)Component.text(LocaleLoader.getString("Acrobatics.SubSkill.Roll.Chance", rollChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", rollChanceLucky) : "")));
        componentBuilder.append((Component)Component.newline());
        componentBuilder.append((Component)Component.text(LocaleLoader.getString("Acrobatics.SubSkill.Roll.GraceChance", gracefulRollChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", gracefulRollChanceLucky) : "")));
        ((TextComponent.Builder)((TextComponent.Builder)componentBuilder.append((Component)Component.newline())).append((Component)Component.text(LocaleLoader.getString("JSON.Hover.Tips")))).append((Component)Component.newline());
        componentBuilder.append((Component)Component.text(this.getTips()));
        componentBuilder.append((Component)Component.newline());
        if (isLucky) {
            componentBuilder.append((Component)Component.text(LocaleLoader.getString("JSON.JWrapper.Perks.Header")));
            componentBuilder.append((Component)Component.newline());
            componentBuilder.append((Component)Component.text(LocaleLoader.getString("JSON.JWrapper.Perks.Lucky", "33")));
        }
    }

    @NotNull
    private Probability getRollProbability(McMMOPlayer mmoPlayer) {
        return ProbabilityUtil.getSubSkillProbability(SubSkillType.ACROBATICS_ROLL, mmoPlayer);
    }

    @Override
    public boolean isSuperAbility() {
        return false;
    }

    @Override
    public boolean isActiveUse() {
        return true;
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @VisibleForTesting
    public boolean canRoll(McMMOPlayer mmoPlayer) {
        return RankUtils.hasUnlockedSubskill(mmoPlayer.getPlayer(), SubSkillType.ACROBATICS_ROLL) && Permissions.isSubSkillEnabled((Permissible)mmoPlayer.getPlayer(), SubSkillType.ACROBATICS_ROLL);
    }

    @VisibleForTesting
    public RollResult rollCheck(McMMOPlayer mmoPlayer, EntityDamageEvent entityDamageEvent) {
        double baseDamage = entityDamageEvent.getFinalDamage();
        boolean isGraceful = mmoPlayer.getPlayer().isSneaking();
        RollResult.Builder rollResultBuilder = new RollResult.Builder(entityDamageEvent, isGraceful);
        Probability probability = isGraceful ? Roll.getGracefulProbability(mmoPlayer) : Roll.getNonGracefulProbability(mmoPlayer);
        double modifiedDamage = Roll.calculateModifiedRollDamage(baseDamage, mcMMO.p.getAdvancedConfig().getRollDamageThreshold() * 2.0);
        rollResultBuilder.modifiedDamage(modifiedDamage);
        boolean isExploiting = this.isPlayerExploitingAcrobatics(mmoPlayer);
        rollResultBuilder.exploiting(isExploiting);
        if (!this.isFatal(mmoPlayer, modifiedDamage) && ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.ACROBATICS, mmoPlayer, probability)) {
            rollResultBuilder.rollSuccess(true);
            rollResultBuilder.exploiting(isExploiting);
            boolean canGainXp = mmoPlayer.getAcrobaticsManager().canGainRollXP();
            if (!isExploiting && canGainXp) {
                rollResultBuilder.xpGain((int)this.calculateRollXP(mmoPlayer, baseDamage, true));
            }
            return rollResultBuilder.build();
        }
        if (!this.isFatal(mmoPlayer, baseDamage)) {
            rollResultBuilder.rollSuccess(false);
            boolean canGainXp = mmoPlayer.getAcrobaticsManager().canGainRollXP();
            if (!isExploiting && canGainXp) {
                rollResultBuilder.xpGain((int)this.calculateRollXP(mmoPlayer, baseDamage, false));
            }
            return rollResultBuilder.build();
        }
        return null;
    }

    @NotNull
    public static Probability getGracefulProbability(McMMOPlayer mmoPlayer) {
        double gracefulOdds = ProbabilityUtil.getSubSkillProbability(SubSkillType.ACROBATICS_ROLL, mmoPlayer).getValue() * 2.0;
        return Probability.ofValue(gracefulOdds);
    }

    public static Probability getNonGracefulProbability(McMMOPlayer mmoPlayer) {
        double gracefulOdds = ProbabilityUtil.getSubSkillProbability(SubSkillType.ACROBATICS_ROLL, mmoPlayer).getValue();
        return Probability.ofValue(gracefulOdds);
    }

    private boolean isPlayerExploitingAcrobatics(McMMOPlayer mmoPlayer) {
        if (!ExperienceConfig.getInstance().isAcrobaticsExploitingPrevented()) {
            return false;
        }
        if (ItemUtils.hasItemInEitherHand(mmoPlayer.getPlayer(), Material.ENDER_PEARL) || mmoPlayer.getPlayer().isInsideVehicle()) {
            if (mmoPlayer.isDebugMode()) {
                mmoPlayer.getPlayer().sendMessage("Acrobatics XP Prevented: Ender Pearl or Inside Vehicle");
            }
            return true;
        }
        if (mmoPlayer.getAcrobaticsManager().hasFallenInLocationBefore(this.getBlockLocation(mmoPlayer))) {
            if (mmoPlayer.isDebugMode()) {
                mmoPlayer.getPlayer().sendMessage("Acrobatics XP Prevented: Fallen in location before");
            }
            return true;
        }
        return false;
    }

    private float calculateRollXP(McMMOPlayer mmoPlayer, double damage, boolean isRoll) {
        damage = Math.min(20.0, damage);
        ItemStack boots = mmoPlayer.getPlayer().getInventory().getBoots();
        float xp = (float)(damage * (double)(isRoll ? ExperienceConfig.getInstance().getRollXPModifier() : ExperienceConfig.getInstance().getFallXPModifier()));
        if (boots != null && boots.containsEnchantment(mcMMO.p.getEnchantmentMapper().getFeatherFalling())) {
            xp = (float)((double)xp * ExperienceConfig.getInstance().getFeatherFallXPModifier());
        }
        return xp;
    }

    protected static double calculateModifiedRollDamage(double damage, double damageThreshold) {
        return Math.max(damage - damageThreshold, 0.0);
    }

    private boolean isFatal(McMMOPlayer mmoPlayer, double damage) {
        return mmoPlayer.getPlayer().getHealth() - damage <= 0.0;
    }

    @Override
    public int getNumRanks() {
        return 0;
    }

    @Override
    public void printInfo(McMMOPlayer mmoPlayer) {
        super.printInfo(mmoPlayer);
        mmoPlayer.getPlayer().sendMessage(LocaleLoader.getString("Commands.MmoInfo.Stats", LocaleLoader.getString("Acrobatics.SubSkill.Roll.Stats", this.getStats(mmoPlayer))));
        mmoPlayer.getPlayer().sendMessage(LocaleLoader.getString("Commands.MmoInfo.Mechanics"));
        mmoPlayer.getPlayer().sendMessage(this.getMechanics());
    }

    @Override
    public String getMechanics() {
        return "Under Construction: This will work in a future update.";
    }

    @Override
    public Double[] getStats(McMMOPlayer mmoPlayer) {
        double playerChanceRoll = ProbabilityUtil.getSubSkillProbability(this.subSkillType, mmoPlayer).getValue();
        double playerChanceGrace = playerChanceRoll * 2.0;
        return new Double[]{playerChanceRoll, playerChanceGrace};
    }

    public void addFallLocation(@NotNull McMMOPlayer mmoPlayer) {
        mmoPlayer.getAcrobaticsManager().addLocationToFallMap(this.getBlockLocation(mmoPlayer));
    }

    @NotNull
    public Location getBlockLocation(@NotNull McMMOPlayer mmoPlayer) {
        return mmoPlayer.getPlayer().getLocation().getBlock().getLocation();
    }
}

