/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.events.chat;

import com.gmail.nossr50.chat.author.Author;
import com.gmail.nossr50.chat.message.AbstractChatMessage;
import com.gmail.nossr50.chat.message.ChatMessage;
import com.gmail.nossr50.datatypes.chat.ChatChannel;
import com.gmail.nossr50.mcmmo.kyori.adventure.audience.Audience;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.Component;
import com.gmail.nossr50.mcmmo.kyori.adventure.text.TextComponent;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class McMMOChatEvent
extends Event
implements Cancellable {
    private boolean cancelled;
    @NotNull
    protected final Plugin plugin;
    @NotNull
    protected final AbstractChatMessage chatMessage;
    @NotNull
    private static final HandlerList handlers = new HandlerList();

    protected McMMOChatEvent(@NotNull Plugin plugin, @NotNull AbstractChatMessage chatMessage, boolean isAsync) {
        super(isAsync);
        this.plugin = plugin;
        this.chatMessage = chatMessage;
    }

    @NotNull
    public Author getAuthor() {
        return this.chatMessage.getAuthor();
    }

    @NotNull
    public Audience getAudience() {
        return this.chatMessage.getAudience();
    }

    public void setAudience(@NotNull Audience audience) {
        this.chatMessage.setAudience(audience);
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public String getDisplayName(ChatChannel chatChannel) {
        return this.getAuthor().getAuthoredName(chatChannel);
    }

    @Deprecated
    @NotNull
    public String getMessage() {
        return this.chatMessage.rawMessage();
    }

    @NotNull
    public String getRawMessage() {
        return this.chatMessage.rawMessage();
    }

    @NotNull
    public TextComponent getComponentMessage() {
        return this.chatMessage.getChatMessage();
    }

    public void setMessagePayload(@NotNull TextComponent chatMessage) {
        this.chatMessage.setChatMessage(chatMessage);
    }

    @Deprecated
    public void setMessage(@NotNull String message) {
        this.chatMessage.setChatMessage(Component.text(message));
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public ChatMessage getChatMessage() {
        return this.chatMessage;
    }
}

