/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.database;

import com.gmail.nossr50.datatypes.database.UpgradeType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.CancellableRunnable;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class UUIDUpdateAsyncTask
extends CancellableRunnable {
    private static final Gson GSON = new Gson();
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    private static final int HARD_LIMIT_PERIOD = 600;
    private static final int RETRY_PERIOD = 60;
    private static final int DELAY_PERIOD = 100;
    private static final int BATCH_SIZE = 100;
    private final CountDownLatch awaiter = new CountDownLatch(1);
    private final mcMMO plugin;
    private final ImmutableList<String> userNames;
    private int position = 0;

    public UUIDUpdateAsyncTask(mcMMO plugin, List<String> userNames) {
        this.plugin = plugin;
        this.userNames = ImmutableList.copyOf(userNames);
    }

    @Override
    public void run() {
        if (this.position == 0) {
            this.plugin.getLogger().info("Starting to check and update UUIDs, total amount of users: " + this.userNames.size());
        }
        ImmutableList batch = this.userNames.subList(this.position, Math.min(this.userNames.size(), this.position + 100));
        HashMap<String, UUID> fetchedUUIDs = new HashMap<String, UUID>();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(PROFILE_URL).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            String body = GSON.toJson((Object)batch.toArray(new String[0]));
            try (OutputStream output = connection.getOutputStream();){
                output.write(body.getBytes());
                output.flush();
            }
            switch (connection.getResponseCode()) {
                case 200: {
                    break;
                }
                case 400: 
                case 403: {
                    this.runTaskLaterAsynchronously(this.plugin, 12000);
                    return;
                }
                default: {
                    this.runTaskLaterAsynchronously(this.plugin, 1200);
                    return;
                }
            }
            try (InputStream input = connection.getInputStream();
                 InputStreamReader reader = new InputStreamReader(input);){
                for (JsonObject jsonProfile : (JsonObject[])GSON.fromJson((Reader)reader, JsonObject[].class)) {
                    UUID id = UUIDUpdateAsyncTask.toUUID(jsonProfile.get("id").getAsString());
                    String name = jsonProfile.get("name").getAsString();
                    fetchedUUIDs.put(name, id);
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Unable to contact mojang API!", e);
            this.runTaskLaterAsynchronously(this.plugin, 1200);
            return;
        }
        if (fetchedUUIDs.size() != 0) {
            mcMMO.getDatabaseManager().saveUserUUIDs(fetchedUUIDs);
        }
        this.position += batch.size();
        this.plugin.getLogger().info(String.format("Conversion progress: %d/%d users", this.position, this.userNames.size()));
        if (this.position + 1 >= this.userNames.size()) {
            mcMMO.getUpgradeManager().setUpgradeCompleted(UpgradeType.ADD_UUIDS);
            this.awaiter.countDown();
            this.plugin.getLogger().info("UUID checks completed");
        } else {
            this.runTaskLaterAsynchronously(this.plugin, 2000);
        }
    }

    private void runTaskLaterAsynchronously(mcMMO plugin, int delay) {
        plugin.getFoliaLib().getScheduler().runLaterAsync(this, (long)delay);
    }

    public void start() {
        this.plugin.getFoliaLib().getScheduler().runAsync(this);
    }

    private static UUID toUUID(String id) {
        return UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
    }

    public void waitUntilFinished() {
        try {
            this.awaiter.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

