/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.excavation;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.treasure.ExcavationTreasure;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.excavation.Excavation;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.List;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class ExcavationManager
extends SkillManager {
    public ExcavationManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.EXCAVATION);
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public void excavationBlockCheck(BlockState blockState) {
        this.excavationBlockCheck(blockState.getBlock());
    }

    public void excavationBlockCheck(Block block) {
        List<ExcavationTreasure> treasures;
        int xp = ExperienceConfig.getInstance().getXp(PrimarySkillType.EXCAVATION, block.getType());
        Objects.requireNonNull(block, "excavationBlockCheck: block cannot be null");
        if (Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.EXCAVATION_ARCHAEOLOGY) && !(treasures = this.getTreasures(block)).isEmpty()) {
            int skillLevel = this.getSkillLevel();
            Location centerOfBlock = Misc.getBlockCenter(block);
            for (ExcavationTreasure treasure : treasures) {
                if (skillLevel < treasure.getDropLevel() || !ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.EXCAVATION, this.mmoPlayer, treasure.getDropProbability())) continue;
                this.processExcavationBonusesOnBlock(treasure, centerOfBlock);
            }
        }
        this.applyXpGain(xp, XPGainReason.PVE, XPGainSource.SELF);
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    public List<ExcavationTreasure> getTreasures(@NotNull BlockState blockState) {
        Objects.requireNonNull(blockState, "blockState cannot be null");
        return this.getTreasures(blockState.getBlock());
    }

    public List<ExcavationTreasure> getTreasures(@NotNull Block block) {
        Objects.requireNonNull(block, "block cannot be null");
        return Excavation.getTreasures(block);
    }

    @Deprecated(forRemoval=true, since="2.2.024")
    @VisibleForTesting
    public void processExcavationBonusesOnBlock(BlockState ignored, ExcavationTreasure treasure, Location location) {
        this.processExcavationBonusesOnBlock(treasure, location);
    }

    public void processExcavationBonusesOnBlock(ExcavationTreasure treasure, Location location) {
        if (ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.EXCAVATION, this.mmoPlayer, this.getArchaelogyExperienceOrbChance())) {
            Misc.spawnExperienceOrb(location, this.getExperienceOrbsReward());
        }
        int xp = 0;
        ItemUtils.spawnItem(this.getPlayer(), location, treasure.getDrop(), ItemSpawnReason.EXCAVATION_TREASURE);
        if ((xp += treasure.getXp()) > 0) {
            this.applyXpGain(xp, XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    public int getExperienceOrbsReward() {
        return this.getArchaeologyRank();
    }

    public double getArchaelogyExperienceOrbChance() {
        return this.getArchaeologyRank() * 2;
    }

    public int getArchaeologyRank() {
        return RankUtils.getRank(this.getPlayer(), SubSkillType.EXCAVATION_ARCHAEOLOGY);
    }

    public void printExcavationDebug(Player player, Block block) {
        if (Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.EXCAVATION_ARCHAEOLOGY)) {
            List<ExcavationTreasure> treasures = Excavation.getTreasures(block);
            if (!treasures.isEmpty()) {
                for (ExcavationTreasure treasure : treasures) {
                    player.sendMessage("|||||||||||||||||||||||||||||||||");
                    player.sendMessage("[mcMMO DEBUG] Treasure found: (" + String.valueOf(treasure.getDrop().getType()) + ")");
                    player.sendMessage("[mcMMO DEBUG] Drop Chance for Treasure: " + treasure.getDropChance());
                    player.sendMessage("[mcMMO DEBUG] Skill Level Required: " + treasure.getDropLevel());
                    player.sendMessage("[mcMMO DEBUG] XP for Treasure: " + treasure.getXp());
                }
            } else {
                player.sendMessage("[mcMMO DEBUG] No treasures found for this block.");
            }
        }
    }

    public void gigaDrillBreaker(Block block) {
        this.excavationBlockCheck(block);
        this.excavationBlockCheck(block);
        SkillUtils.handleDurabilityChange(this.getPlayer().getInventory().getItemInMainHand(), mcMMO.p.getGeneralConfig().getAbilityToolDamage());
    }
}

