/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.fishing;

import com.gmail.nossr50.config.treasure.FishingTreasureConfig;
import com.gmail.nossr50.datatypes.treasure.ShakeTreasure;
import com.gmail.nossr50.util.Misc;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public final class Fishing {
    static final HashMap<Material, List<Enchantment>> ENCHANTABLE_CACHE = new HashMap();

    private Fishing() {
    }

    static List<ShakeTreasure> findPossibleDrops(LivingEntity target) {
        if (FishingTreasureConfig.getInstance().shakeMap.containsKey(target.getType())) {
            return FishingTreasureConfig.getInstance().shakeMap.get(target.getType());
        }
        return null;
    }

    static ItemStack chooseDrop(List<ShakeTreasure> possibleDrops) {
        int dropProbability = Misc.getRandom().nextInt(100);
        double cumulatedProbability = 0.0;
        for (ShakeTreasure treasure : possibleDrops) {
            if (!((double)dropProbability < (cumulatedProbability += treasure.getDropChance()))) continue;
            return treasure.getDrop().clone();
        }
        return null;
    }
}

