/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.MetadataService;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class ItemMetadataUtils {
    @NotNull
    public static final String LEGACY_ABILITY_TOOL_LORE = "mcMMO Ability Tool";

    private ItemMetadataUtils() {
    }

    public static void setSuperAbilityBoostedItem(@NotNull ItemStack itemStack, int originalDigSpeed) {
        if (itemStack.getItemMeta() == null) {
            mcMMO.p.getLogger().severe("Can not assign persistent data to an item with null item metadata");
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        dataContainer.set(MetadataService.NSK_SUPER_ABILITY_BOOSTED_ITEM, PersistentDataType.INTEGER, (Object)originalDigSpeed);
        itemStack.setItemMeta(itemMeta);
    }

    public static boolean isSuperAbilityBoosted(@NotNull ItemStack itemStack) {
        if (itemStack.getItemMeta() == null) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        Integer boostValue = (Integer)dataContainer.get(MetadataService.NSK_SUPER_ABILITY_BOOSTED_ITEM, PersistentDataType.INTEGER);
        return boostValue != null;
    }

    public static int getSuperAbilityToolOriginalDigSpeed(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return 0;
        }
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        if (dataContainer.get(MetadataService.NSK_SUPER_ABILITY_BOOSTED_ITEM, PersistentDataType.INTEGER) == null) {
            mcMMO.p.getLogger().severe("Value should never be null for a boosted item");
            return 0;
        }
        Integer boostValue = (Integer)dataContainer.get(MetadataService.NSK_SUPER_ABILITY_BOOSTED_ITEM, PersistentDataType.INTEGER);
        return Math.max(boostValue, 0);
    }

    public static void removeBonusDigSpeedOnSuperAbilityTool(@NotNull ItemStack itemStack) {
        int originalSpeed = ItemMetadataUtils.getSuperAbilityToolOriginalDigSpeed(itemStack);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            if (itemMeta.hasEnchant(mcMMO.p.getEnchantmentMapper().getEfficiency())) {
                itemMeta.removeEnchant(mcMMO.p.getEnchantmentMapper().getEfficiency());
            }
            if (originalSpeed > 0) {
                itemMeta.addEnchant(mcMMO.p.getEnchantmentMapper().getEfficiency(), originalSpeed, true);
            }
            PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
            dataContainer.remove(MetadataService.NSK_SUPER_ABILITY_BOOSTED_ITEM);
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static boolean isLegacyAbilityTool(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        List lore = itemMeta.getLore();
        if (lore == null || lore.isEmpty()) {
            return false;
        }
        return lore.contains(LEGACY_ABILITY_TOOL_LORE);
    }
}

