/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.random;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.events.skills.secondaryabilities.SubSkillEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.InvalidStaticChance;
import com.gmail.nossr50.util.random.Probability;
import com.gmail.nossr50.util.random.SkillProbabilityType;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ProbabilityUtil {
    @NotNull
    public static final DecimalFormat percent = new DecimalFormat("##0.00%", DecimalFormatSymbols.getInstance(Locale.US));
    public static final double LUCKY_MODIFIER = 1.333;

    @Deprecated(forRemoval=true, since="2.2.010")
    public static double chanceOfSuccessPercentage(@Nullable Player player, @NotNull SubSkillType subSkillType, boolean isLucky) {
        return ProbabilityUtil.chanceOfSuccessPercentage(Objects.requireNonNull(UserManager.getPlayer(player)), subSkillType, isLucky);
    }

    public static double chanceOfSuccessPercentage(@Nullable McMMOPlayer mmoPlayer, @NotNull SubSkillType subSkillType, boolean isLucky) {
        Probability probability = ProbabilityUtil.getSubSkillProbability(subSkillType, mmoPlayer);
        double percentageValue = probability.getValue();
        if (isLucky) {
            percentageValue *= 1.333;
        }
        return percentageValue;
    }

    public static double chanceOfSuccessPercentage(@NotNull Probability probability, boolean isLucky) {
        double percentageValue = probability.getValue();
        if (isLucky) {
            percentageValue *= 1.333;
        }
        return percentageValue;
    }

    @VisibleForTesting
    static Probability getStaticRandomChance(@NotNull SubSkillType subSkillType) throws InvalidStaticChance {
        return switch (subSkillType) {
            case SubSkillType.AXES_ARMOR_IMPACT -> Probability.ofPercent(mcMMO.p.getAdvancedConfig().getImpactChance());
            case SubSkillType.AXES_GREATER_IMPACT -> Probability.ofPercent(mcMMO.p.getAdvancedConfig().getGreaterImpactChance());
            case SubSkillType.TAMING_FAST_FOOD_SERVICE -> Probability.ofPercent(mcMMO.p.getAdvancedConfig().getFastFoodChance());
            default -> throw new InvalidStaticChance();
        };
    }

    static SkillProbabilityType getProbabilityType(@NotNull SubSkillType subSkillType) {
        SkillProbabilityType skillProbabilityType = SkillProbabilityType.DYNAMIC_CONFIGURABLE;
        if (subSkillType == SubSkillType.TAMING_FAST_FOOD_SERVICE || subSkillType == SubSkillType.AXES_ARMOR_IMPACT || subSkillType == SubSkillType.AXES_GREATER_IMPACT) {
            skillProbabilityType = SkillProbabilityType.STATIC_CONFIGURABLE;
        }
        return skillProbabilityType;
    }

    @Deprecated(forRemoval=true, since="2.2.010")
    @NotNull
    private static Probability ofSubSkill(@Nullable Player player, @NotNull SubSkillType subSkillType) {
        return ProbabilityUtil.ofSubSkill(UserManager.getPlayer(player), subSkillType);
    }

    @NotNull
    private static Probability ofSubSkill(@Nullable McMMOPlayer mmoPlayer, @NotNull SubSkillType subSkillType) {
        switch (ProbabilityUtil.getProbabilityType(subSkillType)) {
            case DYNAMIC_CONFIGURABLE: {
                double skillLevel = mmoPlayer != null ? (double)mmoPlayer.getSkillLevel(subSkillType.getParentSkill()) : 0.0;
                double probabilityCeiling = mcMMO.p.getAdvancedConfig().getMaximumProbability(subSkillType);
                double maxBonusLevel = mcMMO.p.getAdvancedConfig().getMaxBonusLevel(subSkillType);
                return ProbabilityUtil.calculateCurrentSkillProbability(skillLevel, 0.0, probabilityCeiling, maxBonusLevel);
            }
            case STATIC_CONFIGURABLE: {
                try {
                    return ProbabilityUtil.getStaticRandomChance(subSkillType);
                }
                catch (InvalidStaticChance invalidStaticChance) {
                    throw new RuntimeException(invalidStaticChance);
                }
            }
        }
        throw new IllegalStateException("No case in switch statement for Skill Probability Type!");
    }

    @Deprecated(forRemoval=true, since="2.2.010")
    public static boolean isSkillRNGSuccessful(@NotNull SubSkillType subSkillType, @Nullable Player player) {
        return ProbabilityUtil.isSkillRNGSuccessful(subSkillType, UserManager.getPlayer(player));
    }

    public static boolean isSkillRNGSuccessful(@NotNull SubSkillType subSkillType, @Nullable McMMOPlayer mmoPlayer) {
        boolean isLucky;
        Probability probability = ProbabilityUtil.getSkillProbability(subSkillType, mmoPlayer);
        boolean bl = isLucky = mmoPlayer != null && Permissions.lucky((Permissible)mmoPlayer.getPlayer(), subSkillType.getParentSkill());
        if (isLucky) {
            return probability.evaluate(1.333);
        }
        return probability.evaluate();
    }

    public static boolean isSkillRNGSuccessful(@NotNull SubSkillType subSkillType, @Nullable McMMOPlayer mmoPlayer, double probabilityMultiplier) {
        boolean isLucky;
        Probability probability = ProbabilityUtil.getSkillProbability(subSkillType, mmoPlayer);
        boolean bl = isLucky = mmoPlayer != null && Permissions.lucky((Permissible)mmoPlayer.getPlayer(), subSkillType.getParentSkill());
        if (isLucky) {
            return probability.evaluate(1.333, probabilityMultiplier);
        }
        return probability.evaluate();
    }

    @Deprecated(forRemoval=true)
    public static Probability getSkillProbability(@NotNull SubSkillType subSkillType, @Nullable Player player) {
        return ProbabilityUtil.getSkillProbability(subSkillType, UserManager.getPlayer(player));
    }

    public static Probability getSkillProbability(@NotNull SubSkillType subSkillType, @Nullable McMMOPlayer mmoPlayer) {
        Probability probability = ProbabilityUtil.getSubSkillProbability(subSkillType, mmoPlayer);
        if (mmoPlayer != null) {
            SubSkillEvent subSkillEvent = EventUtils.callSubSkillEvent(mmoPlayer, subSkillType);
            if (subSkillEvent.isCancelled()) {
                return Probability.ALWAYS_FAILS;
            }
            double resultModifier = subSkillEvent.getResultModifier();
            if (resultModifier != 1.0) {
                probability = Probability.ofPercent(probability.getValue() * resultModifier);
            }
        }
        return probability;
    }

    @Deprecated(forRemoval=true, since="2.2.010")
    public static boolean isStaticSkillRNGSuccessful(@NotNull PrimarySkillType primarySkillType, @Nullable Player player, double probabilityPercentage) {
        return ProbabilityUtil.isStaticSkillRNGSuccessful(primarySkillType, player, Probability.ofPercent(probabilityPercentage));
    }

    public static boolean isStaticSkillRNGSuccessful(@NotNull PrimarySkillType primarySkillType, @Nullable McMMOPlayer mmoPlayer, double probabilityPercentage) {
        Probability probability = Probability.ofPercent(probabilityPercentage);
        return ProbabilityUtil.isStaticSkillRNGSuccessful(primarySkillType, mmoPlayer, probability);
    }

    @Deprecated(forRemoval=true, since="2.2.010")
    public static boolean isStaticSkillRNGSuccessful(@NotNull PrimarySkillType primarySkillType, @Nullable Player player, @NotNull Probability probability) {
        return ProbabilityUtil.isStaticSkillRNGSuccessful(primarySkillType, UserManager.getPlayer(player), probability);
    }

    public static boolean isStaticSkillRNGSuccessful(@NotNull PrimarySkillType primarySkillType, @Nullable McMMOPlayer mmoPlayer, @NotNull Probability probability) {
        boolean isLucky;
        boolean bl = isLucky = mmoPlayer != null && Permissions.lucky((Permissible)mmoPlayer.getPlayer(), primarySkillType);
        if (isLucky) {
            return probability.evaluate(1.333);
        }
        return probability.evaluate();
    }

    @Deprecated(forRemoval=true, since="2.2.010")
    public static boolean isNonRNGSkillActivationSuccessful(@NotNull SubSkillType subSkillType, @NotNull Player player) {
        return ProbabilityUtil.isNonRNGSkillActivationSuccessful(subSkillType, Objects.requireNonNull(UserManager.getPlayer(player)));
    }

    public static boolean isNonRNGSkillActivationSuccessful(@NotNull SubSkillType subSkillType, @NotNull McMMOPlayer mmoPlayer) {
        return !EventUtils.callSubSkillEvent(mmoPlayer, subSkillType).isCancelled();
    }

    @Deprecated(forRemoval=true, since="2.2.010")
    @NotNull
    public static Probability getSubSkillProbability(@NotNull SubSkillType subSkillType, @Nullable Player player) {
        return ProbabilityUtil.ofSubSkill(player, subSkillType);
    }

    @NotNull
    public static Probability getSubSkillProbability(@NotNull SubSkillType subSkillType, @Nullable McMMOPlayer mmoPlayer) {
        return ProbabilityUtil.ofSubSkill(mmoPlayer, subSkillType);
    }

    @NotNull
    public static String[] getRNGDisplayValues(@Nullable McMMOPlayer mmoPlayer, @NotNull SubSkillType subSkill) {
        double firstValue = ProbabilityUtil.chanceOfSuccessPercentage(mmoPlayer, subSkill, false);
        double secondValue = ProbabilityUtil.chanceOfSuccessPercentage(mmoPlayer, subSkill, true);
        return new String[]{percent.format(firstValue), percent.format(secondValue)};
    }

    @NotNull
    public static String[] getRNGDisplayValues(@NotNull Probability probability) {
        double firstValue = ProbabilityUtil.chanceOfSuccessPercentage(probability, false);
        double secondValue = ProbabilityUtil.chanceOfSuccessPercentage(probability, true);
        return new String[]{percent.format(firstValue), percent.format(secondValue)};
    }

    public static Probability calculateCurrentSkillProbability(double skillLevel, double floor, double ceiling, double maxBonusLevel) {
        if (skillLevel >= maxBonusLevel || maxBonusLevel <= 0.0) {
            return Probability.ofPercent(ceiling);
        }
        double odds = skillLevel / maxBonusLevel * ceiling;
        return Probability.ofPercent(Math.min(Math.max(floor, odds), ceiling));
    }
}

