/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.commands.party.PartyAcceptCommand;
import com.gmail.nossr50.commands.party.PartyChangeOwnerCommand;
import com.gmail.nossr50.commands.party.PartyChangePasswordCommand;
import com.gmail.nossr50.commands.party.PartyCreateCommand;
import com.gmail.nossr50.commands.party.PartyDisbandCommand;
import com.gmail.nossr50.commands.party.PartyHelpCommand;
import com.gmail.nossr50.commands.party.PartyInfoCommand;
import com.gmail.nossr50.commands.party.PartyInviteCommand;
import com.gmail.nossr50.commands.party.PartyItemShareCommand;
import com.gmail.nossr50.commands.party.PartyJoinCommand;
import com.gmail.nossr50.commands.party.PartyKickCommand;
import com.gmail.nossr50.commands.party.PartyLockCommand;
import com.gmail.nossr50.commands.party.PartyQuitCommand;
import com.gmail.nossr50.commands.party.PartyRenameCommand;
import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.commands.party.PartyXpShareCommand;
import com.gmail.nossr50.commands.party.alliance.PartyAllianceCommand;
import com.gmail.nossr50.commands.party.teleport.PtpCommand;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PartyCommand
implements TabExecutor {
    private final List<String> PARTY_SUBCOMMANDS;
    private final List<String> XPSHARE_COMPLETIONS = ImmutableList.of((Object)"none", (Object)"equal");
    private final List<String> ITEMSHARE_COMPLETIONS = ImmutableList.of((Object)"none", (Object)"equal", (Object)"random", (Object)"loot", (Object)"mining", (Object)"herbalism", (Object)"woodcutting", (Object)"misc");
    private final CommandExecutor partyJoinCommand = new PartyJoinCommand();
    private final CommandExecutor partyAcceptCommand = new PartyAcceptCommand();
    private final CommandExecutor partyCreateCommand = new PartyCreateCommand();
    private final CommandExecutor partyQuitCommand = new PartyQuitCommand();
    private final CommandExecutor partyXpShareCommand = new PartyXpShareCommand();
    private final CommandExecutor partyItemShareCommand = new PartyItemShareCommand();
    private final CommandExecutor partyInviteCommand = new PartyInviteCommand();
    private final CommandExecutor partyKickCommand = new PartyKickCommand();
    private final CommandExecutor partyDisbandCommand = new PartyDisbandCommand();
    private final CommandExecutor partyChangeOwnerCommand = new PartyChangeOwnerCommand();
    private final CommandExecutor partyLockCommand = new PartyLockCommand();
    private final CommandExecutor partyChangePasswordCommand = new PartyChangePasswordCommand();
    private final CommandExecutor partyRenameCommand = new PartyRenameCommand();
    private final CommandExecutor partyInfoCommand = new PartyInfoCommand();
    private final CommandExecutor partyHelpCommand = new PartyHelpCommand();
    private final CommandExecutor partyTeleportCommand = new PtpCommand();
    private final CommandExecutor partyAllianceCommand = new PartyAllianceCommand();

    public PartyCommand() {
        ArrayList<String> subcommands = new ArrayList<String>();
        for (PartySubcommandType subcommand : PartySubcommandType.values()) {
            subcommands.add(subcommand.toString());
        }
        Collections.sort(subcommands);
        this.PARTY_SUBCOMMANDS = ImmutableList.copyOf(subcommands);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (CommandUtils.noConsoleUsage(sender)) {
            return true;
        }
        if (!Permissions.party((Permissible)sender)) {
            sender.sendMessage(command.getPermissionMessage());
            return true;
        }
        Player player = (Player)sender;
        if (!UserManager.hasPlayerDataKey((Entity)player)) {
            return true;
        }
        McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
        if (mmoPlayer == null) {
            player.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
            return true;
        }
        if (args.length < 1) {
            if (!mmoPlayer.inParty()) {
                sender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
                return this.printUsage(player);
            }
            return this.partyInfoCommand.onCommand(sender, command, label, args);
        }
        PartySubcommandType subcommand = PartySubcommandType.getSubcommand(args[0]);
        if (subcommand == null) {
            return this.printUsage(player);
        }
        if (subcommand != PartySubcommandType.LOCK && subcommand != PartySubcommandType.UNLOCK && !Permissions.partySubcommand((Permissible)sender, subcommand)) {
            sender.sendMessage(command.getPermissionMessage());
            return true;
        }
        switch (subcommand) {
            case JOIN: {
                return this.partyJoinCommand.onCommand(sender, command, label, args);
            }
            case ACCEPT: {
                return this.partyAcceptCommand.onCommand(sender, command, label, args);
            }
            case CREATE: {
                return this.partyCreateCommand.onCommand(sender, command, label, args);
            }
            case HELP: {
                return this.partyHelpCommand.onCommand(sender, command, label, args);
            }
        }
        if (!mmoPlayer.inParty()) {
            sender.sendMessage(LocaleLoader.getString("Commands.Party.None"));
            return this.printUsage(player);
        }
        switch (subcommand) {
            case INFO: {
                return this.partyInfoCommand.onCommand(sender, command, label, args);
            }
            case QUIT: {
                return this.partyQuitCommand.onCommand(sender, command, label, args);
            }
            case INVITE: {
                return this.partyInviteCommand.onCommand(sender, command, label, args);
            }
            case TELEPORT: {
                return this.partyTeleportCommand.onCommand(sender, command, label, this.extractArgs(args));
            }
        }
        if (!mmoPlayer.getParty().getLeader().getUniqueId().equals(player.getUniqueId())) {
            sender.sendMessage(LocaleLoader.getString("Party.NotOwner"));
            return true;
        }
        return switch (subcommand) {
            case PartySubcommandType.XPSHARE -> this.partyXpShareCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.ITEMSHARE -> this.partyItemShareCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.KICK -> this.partyKickCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.DISBAND -> this.partyDisbandCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.OWNER -> this.partyChangeOwnerCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.LOCK, PartySubcommandType.UNLOCK -> this.partyLockCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.PASSWORD -> this.partyChangePasswordCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.RENAME -> this.partyRenameCommand.onCommand(sender, command, label, args);
            case PartySubcommandType.ALLIANCE -> this.partyAllianceCommand.onCommand(sender, command, label, args);
            default -> true;
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        switch (args.length) {
            case 1: {
                return (List)StringUtil.copyPartialMatches((String)args[0], this.PARTY_SUBCOMMANDS, new ArrayList(this.PARTY_SUBCOMMANDS.size()));
            }
            case 2: {
                PartySubcommandType subcommand = PartySubcommandType.getSubcommand(args[0]);
                if (subcommand == null) {
                    return ImmutableList.of();
                }
                List<String> playerNames = CommandUtils.getOnlinePlayerNames(sender);
                switch (subcommand) {
                    case JOIN: 
                    case INVITE: 
                    case KICK: 
                    case OWNER: {
                        return (List)StringUtil.copyPartialMatches((String)args[1], playerNames, new ArrayList(playerNames.size()));
                    }
                    case XPSHARE: {
                        return (List)StringUtil.copyPartialMatches((String)args[1], this.XPSHARE_COMPLETIONS, new ArrayList(this.XPSHARE_COMPLETIONS.size()));
                    }
                    case ITEMSHARE: {
                        return (List)StringUtil.copyPartialMatches((String)args[1], this.ITEMSHARE_COMPLETIONS, new ArrayList(this.ITEMSHARE_COMPLETIONS.size()));
                    }
                    case LOCK: 
                    case CHAT: {
                        return (List)StringUtil.copyPartialMatches((String)args[1], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
                    }
                    case PASSWORD: {
                        return (List)StringUtil.copyPartialMatches((String)args[1], CommandUtils.RESET_OPTIONS, new ArrayList(CommandUtils.RESET_OPTIONS.size()));
                    }
                    case TELEPORT: {
                        List matches = (List)StringUtil.copyPartialMatches((String)args[1], PtpCommand.TELEPORT_SUBCOMMANDS, new ArrayList(PtpCommand.TELEPORT_SUBCOMMANDS.size()));
                        if (matches.isEmpty()) {
                            Player player = (Player)sender;
                            McMMOPlayer mmoPlayer = UserManager.getPlayer(player);
                            if (mmoPlayer == null) {
                                sender.sendMessage(LocaleLoader.getString("Profile.PendingLoad"));
                                return ImmutableList.of();
                            }
                            if (mmoPlayer.getParty() == null) {
                                return ImmutableList.of();
                            }
                            Party party = mmoPlayer.getParty();
                            playerNames = party.getOnlinePlayerNames((CommandSender)player);
                            return (List)StringUtil.copyPartialMatches((String)args[1], playerNames, new ArrayList(playerNames.size()));
                        }
                        return matches;
                    }
                }
                return ImmutableList.of();
            }
            case 3: {
                if (PartySubcommandType.getSubcommand(args[0]) == PartySubcommandType.ITEMSHARE && this.isItemShareCategory(args[1])) {
                    return (List)StringUtil.copyPartialMatches((String)args[2], CommandUtils.TRUE_FALSE_OPTIONS, new ArrayList(CommandUtils.TRUE_FALSE_OPTIONS.size()));
                }
                return ImmutableList.of();
            }
        }
        return ImmutableList.of();
    }

    private boolean printUsage(Player player) {
        player.sendMessage(LocaleLoader.getString("Party.Help.0", "/party join"));
        player.sendMessage(LocaleLoader.getString("Party.Help.1", "/party create"));
        player.sendMessage(LocaleLoader.getString("Party.Help.2", "/party ?"));
        return true;
    }

    private String[] extractArgs(String[] args) {
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private boolean isItemShareCategory(String category) {
        return category.equalsIgnoreCase("loot") || category.equalsIgnoreCase("mining") || category.equalsIgnoreCase("herbalism") || category.equalsIgnoreCase("woodcutting") || category.equalsIgnoreCase("misc");
    }
}

