/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.text.TextComponentFactory;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class MmoInfoCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] args) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (args == null || args.length < 1 || args[0] == null || args[0].isEmpty()) {
                return false;
            }
            if (Permissions.mmoinfo((Permissible)player)) {
                if (args[0].equalsIgnoreCase("???")) {
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Header"));
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.SubSkillHeader", "???"));
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.DetailsHeader"));
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Mystery"));
                    return true;
                }
                SubSkillType subSkillType = this.matchSubSkill(args[0]);
                if (subSkillType != null) {
                    this.displayInfo(player, subSkillType);
                } else {
                    player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.NoMatch"));
                }
                return true;
            }
        }
        return false;
    }

    public SubSkillType matchSubSkill(String name) {
        for (SubSkillType subSkillType : SubSkillType.values()) {
            if (!subSkillType.getNiceNameNoSpaces(subSkillType).equalsIgnoreCase(name) && !subSkillType.name().equalsIgnoreCase(name)) continue;
            return subSkillType;
        }
        return null;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], mcMMO.p.getSkillTools().EXACT_SUBSKILL_NAMES, new ArrayList(mcMMO.p.getSkillTools().EXACT_SUBSKILL_NAMES.size()));
        }
        return ImmutableList.of();
    }

    private void displayInfo(Player player, SubSkillType subSkillType) {
        player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.Header"));
        player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.SubSkillHeader", subSkillType.getLocaleName()));
        player.sendMessage(LocaleLoader.getString("Commands.MmoInfo.DetailsHeader"));
        TextComponentFactory.sendPlayerSubSkillWikiLink(player, subSkillType.getLocaleName(), subSkillType);
    }
}

