/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.treasure;

import com.gmail.nossr50.datatypes.treasure.EnchantmentWrapper;
import com.gmail.nossr50.datatypes.treasure.FishingTreasure;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingTreasureBook
extends FishingTreasure {
    @Nullable
    private final Set<Enchantment> blackListedEnchantments;
    @Nullable
    private final Set<Enchantment> whiteListedEnchantments;
    @NotNull
    private final List<EnchantmentWrapper> legalEnchantments;

    public FishingTreasureBook(@NotNull ItemStack enchantedBook, int xp, @Nullable Set<Enchantment> blackListedEnchantments, @Nullable Set<Enchantment> whiteListedEnchantments) {
        super(enchantedBook, xp);
        this.blackListedEnchantments = blackListedEnchantments;
        this.whiteListedEnchantments = whiteListedEnchantments;
        this.legalEnchantments = new ArrayList<EnchantmentWrapper>();
        this.initLegalEnchantments();
    }

    private void initLegalEnchantments() {
        LogUtils.debug(mcMMO.p.getLogger(), "Registering enchantments for Fishing Book...");
        for (Enchantment enchantment : Enchantment.values()) {
            if (!this.isEnchantAllowed(enchantment)) continue;
            this.addAllLegalEnchants(enchantment);
        }
    }

    @NotNull
    public List<EnchantmentWrapper> getLegalEnchantments() {
        return this.legalEnchantments;
    }

    @Nullable
    private Set<Enchantment> getBlacklistedEnchantments() {
        return this.blackListedEnchantments;
    }

    @Nullable
    private Set<Enchantment> getWhitelistedEnchantments() {
        return this.whiteListedEnchantments;
    }

    private void addAllLegalEnchants(@NotNull Enchantment enchantment) {
        int legalEnchantCap = enchantment.getMaxLevel();
        for (int i = 0; i < legalEnchantCap; ++i) {
            int enchantLevel = i + 1;
            EnchantmentWrapper enchantmentWrapper = new EnchantmentWrapper(enchantment, enchantLevel);
            this.legalEnchantments.add(enchantmentWrapper);
        }
    }

    private boolean isEnchantAllowed(@NotNull Enchantment enchantment) {
        if (this.whiteListedEnchantments != null && !this.whiteListedEnchantments.isEmpty()) {
            return this.whiteListedEnchantments.contains(enchantment);
        }
        if (this.blackListedEnchantments != null && !this.blackListedEnchantments.isEmpty()) {
            return !this.blackListedEnchantments.contains(enchantment);
        }
        return true;
    }
}

