/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.events.skills.taming;

import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.events.experience.McMMOPlayerExperienceEvent;
import com.google.common.base.Preconditions;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class McMMOPlayerTameEntityEvent
extends McMMOPlayerExperienceEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final McMMOPlayer mmoPlayer;
    private float xpGained;
    private final Entity tamedEntity;

    public McMMOPlayerTameEntityEvent(@NotNull McMMOPlayer mmoPlayer, float xp, @NotNull Entity tamedEntity) {
        super(mmoPlayer.getPlayer(), PrimarySkillType.TAMING, XPGainReason.PVE);
        this.mmoPlayer = mmoPlayer;
        this.xpGained = xp;
        this.tamedEntity = tamedEntity;
    }

    @NotNull
    public McMMOPlayer getMcMMOPlayer() {
        return this.mmoPlayer;
    }

    public float getXpGained() {
        return this.xpGained;
    }

    public void setXpGained(float xpGained) {
        Preconditions.checkArgument((boolean)Float.isFinite(xpGained), (Object)"new gained xp must be a number");
        Preconditions.checkArgument((xpGained > 0.0f ? 1 : 0) != 0, (Object)"new gained xp must be a positive number");
        this.xpGained = xpGained;
    }

    @NotNull
    public Entity getTamedEntity() {
        return this.tamedEntity;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        super.setCancelled(cancelled);
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

