/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.commands;

import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.commands.MctopCommandDisplayTask;
import com.gmail.nossr50.util.CancellableRunnable;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class McTopCommandAsyncTask
extends CancellableRunnable {
    private final CommandSender sender;
    private final PrimarySkillType skill;
    private final int page;
    private final boolean useBoard;
    private final boolean useChat;

    public McTopCommandAsyncTask(int page, PrimarySkillType skill, CommandSender sender, boolean useBoard, boolean useChat) {
        Validate.isTrue((useBoard || useChat ? 1 : 0) != 0, (String)"Attempted to start a rank retrieval with both board and chat off", (Object[])new Object[0]);
        Validate.notNull((Object)sender, (String)"Attempted to start a rank retrieval with no recipient", (Object[])new Object[0]);
        if (useBoard) {
            Validate.isTrue((boolean)(sender instanceof Player), (String)"Attempted to start a rank retrieval displaying scoreboard to a non-player", (Object[])new Object[0]);
        }
        this.page = page;
        this.skill = skill;
        this.sender = sender;
        this.useBoard = useBoard;
        this.useChat = useChat;
    }

    @Override
    public void run() {
        List<PlayerStat> userStats = mcMMO.getDatabaseManager().readLeaderboard(this.skill, this.page, 10);
        mcMMO.p.getFoliaLib().getScheduler().runNextTick((Consumer)new MctopCommandDisplayTask(userStats, this.page, this.skill, this.sender, this.useBoard, this.useChat));
    }
}

