/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.herbalism;

import com.gmail.nossr50.api.ItemSpawnReason;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.BlockSnapshot;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.meta.RecentlyReplantedCropMeta;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.datatypes.treasure.HylianTreasure;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.DelayedCropReplant;
import com.gmail.nossr50.runnables.skills.DelayedHerbalismXPCheckTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.herbalism.Herbalism;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.CancellableRunnable;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.random.ProbabilityUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import com.gmail.nossr50.util.text.ConfigStringUtils;
import com.gmail.nossr50.util.text.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class HerbalismManager
extends SkillManager {
    private static final HashMap<String, Integer> plantBreakLimits = new HashMap();
    private static final String CACTUS_ID = "cactus";
    private static final String CACTUS_FLOWER_STR = "cactus_flower";
    private static final String BAMBOO_ID = "bamboo";
    private static final String SUGAR_CANE_ID = "sugar_cane";
    private static final String KELP_ID = "kelp";
    private static final String KELP_PLANT_ID = "kelp_plant";
    private static final String CHORUS_PLANT_ID = "chorus_plant";
    private static final String SWEET_BERRY_BUSH_ID = "sweet_berry_bush";

    public HerbalismManager(McMMOPlayer mmoPlayer) {
        super(mmoPlayer, PrimarySkillType.HERBALISM);
    }

    public boolean canGreenThumbBlock(BlockState blockState) {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.HERBALISM_GREEN_THUMB)) {
            return false;
        }
        Player player = this.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        return item.getAmount() > 0 && item.getType() == Material.WHEAT_SEEDS && BlockUtils.canMakeMossy(blockState.getBlock()) && Permissions.greenThumbBlock((Permissible)player, blockState.getType());
    }

    public boolean canUseShroomThumb(BlockState blockState) {
        if (!BlockUtils.canMakeShroomy(blockState)) {
            return false;
        }
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.HERBALISM_SHROOM_THUMB)) {
            return false;
        }
        Player player = this.getPlayer();
        PlayerInventory inventory = player.getInventory();
        Material itemType = inventory.getItemInMainHand().getType();
        return (itemType == Material.BROWN_MUSHROOM || itemType == Material.RED_MUSHROOM) && inventory.contains(Material.BROWN_MUSHROOM, 1) && inventory.contains(Material.RED_MUSHROOM, 1) && Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_SHROOM_THUMB);
    }

    public void processBerryBushHarvesting(@NotNull BlockState blockState) {
        if (blockState.getType().toString().equalsIgnoreCase(SWEET_BERRY_BUSH_ID)) {
            BlockData blockData;
            if (this.mmoPlayer.isDebugMode()) {
                this.mmoPlayer.getPlayer().sendMessage("Processing sweet berry bush rewards");
            }
            if ((blockData = blockState.getBlockData()) instanceof Ageable) {
                Ageable ageable = (Ageable)blockData;
                int rewardByAge = 0;
                if (ageable.getAge() == 2) {
                    rewardByAge = 1;
                } else if (ageable.getAge() == 3) {
                    rewardByAge = 2;
                } else {
                    return;
                }
                if (this.mmoPlayer.isDebugMode()) {
                    this.mmoPlayer.getPlayer().sendMessage("Bush Reward Multiplier: " + rewardByAge);
                }
                int xpReward = ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, blockState.getType()) * rewardByAge;
                if (this.mmoPlayer.isDebugMode()) {
                    this.mmoPlayer.getPlayer().sendMessage("Bush XP: " + xpReward);
                }
                CheckBushAge checkBushAge = new CheckBushAge(blockState.getBlock(), this.mmoPlayer, xpReward);
                mcMMO.p.getFoliaLib().getScheduler().runAtLocationLater(blockState.getLocation(), (Consumer)checkBushAge, 1L);
            }
        }
    }

    public boolean canUseHylianLuck() {
        if (!RankUtils.hasUnlockedSubskill(this.getPlayer(), SubSkillType.HERBALISM_HYLIAN_LUCK)) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)this.getPlayer(), SubSkillType.HERBALISM_HYLIAN_LUCK);
    }

    public boolean canActivateAbility() {
        return this.mmoPlayer.getToolPreparationMode(ToolType.HOE) && Permissions.greenTerra((Permissible)this.getPlayer());
    }

    public boolean isGreenTerraActive() {
        return this.mmoPlayer.getAbilityMode(SuperAbilityType.GREEN_TERRA);
    }

    public int farmersDiet(int eventFoodLevel) {
        return SkillUtils.handleFoodSkills(this.getPlayer(), eventFoodLevel, SubSkillType.HERBALISM_FARMERS_DIET);
    }

    public void processGreenTerraBlockConversion(BlockState blockState) {
        ItemStack seed;
        Player player = this.getPlayer();
        if (!Permissions.greenThumbBlock((Permissible)player, blockState.getType())) {
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        if (!playerInventory.containsAtLeast(seed = new ItemStack(Material.WHEAT_SEEDS), 1)) {
            NotificationManager.sendPlayerInformation(player, NotificationType.REQUIREMENTS_NOT_MET, "Herbalism.Ability.GTe.NeedMore");
            return;
        }
        playerInventory.removeItem(new ItemStack[]{seed});
        Herbalism.convertGreenTerraBlocks(blockState);
        blockState.update(true);
    }

    public void processGreenTerraBlockConversion(Block block) {
        this.processGreenTerraBlockConversion(block.getState());
    }

    public void processHerbalismBlockBreakEvent(BlockBreakEvent blockBreakEvent) {
        HashSet<Block> brokenBlocks;
        Player player = this.getPlayer();
        Block block = blockBreakEvent.getBlock();
        if (mcMMO.p.getGeneralConfig().getHerbalismPreventAFK() && player.isInsideVehicle()) {
            if (block.hasMetadata("mcMMO: Recently Replanted")) {
                block.removeMetadata("mcMMO: Recently Replanted", (Plugin)mcMMO.p);
            }
            return;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageableCrop = (Ageable)blockData;
            if (!block.getMetadata("mcMMO: Recently Replanted").isEmpty() && ((MetadataValue)block.getMetadata("mcMMO: Recently Replanted").get(0)).asBoolean()) {
                if (this.isAgeableMature(ageableCrop)) {
                    block.removeMetadata("mcMMO: Recently Replanted", (Plugin)mcMMO.p);
                } else {
                    blockBreakEvent.setCancelled(true);
                    return;
                }
            }
        }
        if ((brokenBlocks = this.getBrokenHerbalismBlocks(blockBreakEvent)).isEmpty()) {
            return;
        }
        this.processHerbalismOnBlocksBroken(blockBreakEvent, brokenBlocks);
    }

    private void processHerbalismOnBlocksBroken(BlockBreakEvent blockBreakEvent, HashSet<Block> brokenPlants) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        BlockState originalBreak = blockBreakEvent.getBlock().getState();
        boolean greenThumbActivated = false;
        if (Permissions.greenThumbPlant((Permissible)this.getPlayer(), originalBreak.getType()) && mcMMO.p.getGeneralConfig().isGreenThumbReplantableCrop(originalBreak.getType()) && !this.getPlayer().isSneaking()) {
            greenThumbActivated = this.processGreenThumbPlants(originalBreak, blockBreakEvent, this.isGreenTerraActive());
        }
        this.checkDoubleDropsOnBrokenPlants(blockBreakEvent.getPlayer(), brokenPlants);
        ArrayList<BlockSnapshot> delayedChorusBlocks = new ArrayList<BlockSnapshot>();
        HashSet<Block> noDelayPlantBlocks = new HashSet<Block>();
        for (Block brokenPlant : brokenPlants) {
            if (brokenPlant.getLocation().equals((Object)originalBreak.getBlock().getLocation())) {
                if (!mcMMO.getUserBlockTracker().isIneligible(originalBreak)) {
                    noDelayPlantBlocks.add(brokenPlant);
                    continue;
                }
                if (this.isChorusTree(brokenPlant.getType())) {
                    delayedChorusBlocks.add(new BlockSnapshot(brokenPlant.getType(), brokenPlant));
                    continue;
                }
                noDelayPlantBlocks.add(brokenPlant);
                continue;
            }
            if (this.isChorusTree(brokenPlant.getType())) {
                delayedChorusBlocks.add(new BlockSnapshot(brokenPlant.getType(), brokenPlant));
                continue;
            }
            noDelayPlantBlocks.add(brokenPlant);
        }
        if (!noDelayPlantBlocks.isEmpty()) {
            this.awardXPForPlantBlocks(noDelayPlantBlocks);
        }
        if (!delayedChorusBlocks.isEmpty()) {
            DelayedHerbalismXPCheckTask delayedHerbalismXPCheckTask = new DelayedHerbalismXPCheckTask(this.mmoPlayer, delayedChorusBlocks);
            mcMMO.p.getFoliaLib().getScheduler().runAtEntity((Entity)this.mmoPlayer.getPlayer(), (Consumer)delayedHerbalismXPCheckTask);
        }
    }

    public void checkDoubleDropsOnBrokenPlants(Player player, Collection<Block> brokenPlants) {
        if (!RankUtils.hasUnlockedSubskill(player, SubSkillType.HERBALISM_DOUBLE_DROPS) || !Permissions.isSubSkillEnabled((Permissible)player, SubSkillType.HERBALISM_DOUBLE_DROPS)) {
            return;
        }
        for (Block brokenPlant : brokenPlants) {
            BlockState brokenPlantState = brokenPlant.getState();
            BlockData plantData = brokenPlantState.getBlockData();
            if (!mcMMO.getUserBlockTracker().isIneligible(brokenPlant)) {
                if (plantData instanceof Ageable) {
                    Ageable ageable = (Ageable)plantData;
                    if (!this.isAgeableMature(ageable) && !this.isBizarreAgeable(plantData) || !this.checkDoubleDrop(brokenPlant)) continue;
                    this.markForBonusDrops(brokenPlant);
                    continue;
                }
                if (!this.checkDoubleDrop(brokenPlant)) continue;
                this.markForBonusDrops(brokenPlant);
                continue;
            }
            if (!this.isAgeableAndFullyMature(plantData) || this.isBizarreAgeable(plantData)) continue;
            this.markForBonusDrops(brokenPlant);
        }
    }

    public boolean isBizarreAgeable(BlockData blockData) {
        if (blockData instanceof Ageable) {
            return switch (blockData.getMaterial()) {
                case Material.CACTUS, Material.KELP, Material.SUGAR_CANE, Material.BAMBOO -> true;
                default -> false;
            };
        }
        return false;
    }

    public void markForBonusDrops(Block block) {
        boolean awardTriple = this.mmoPlayer.getAbilityMode(SuperAbilityType.GREEN_TERRA);
        BlockUtils.markDropsAsBonus(block, awardTriple);
    }

    public boolean isAgeableAndFullyMature(BlockData plantData) {
        return plantData instanceof Ageable && this.isAgeableMature((Ageable)plantData);
    }

    public void awardXPForPlantBlocks(HashSet<Block> brokenPlants) {
        int xpToReward = 0;
        int firstXpReward = -1;
        for (Block brokenPlantBlock : brokenPlants) {
            BlockState brokenBlockNewState = brokenPlantBlock.getState();
            BlockData plantData = brokenBlockNewState.getBlockData();
            if (mcMMO.getUserBlockTracker().isIneligible(brokenBlockNewState)) {
                if (this.isAgeableAndFullyMature(plantData) && !this.isBizarreAgeable(plantData)) {
                    xpToReward += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, brokenBlockNewState.getType());
                    if (firstXpReward == -1) {
                        firstXpReward = xpToReward;
                    }
                }
                mcMMO.getUserBlockTracker().setEligible(brokenBlockNewState);
                continue;
            }
            if (plantData instanceof Ageable) {
                Ageable plantAgeable = (Ageable)plantData;
                if (!this.isAgeableMature(plantAgeable) && !this.isBizarreAgeable(plantData)) continue;
                xpToReward += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, brokenBlockNewState.getType());
                if (firstXpReward != -1) continue;
                firstXpReward = xpToReward;
                continue;
            }
            xpToReward += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, brokenPlantBlock.getType());
            if (firstXpReward != -1) continue;
            firstXpReward = xpToReward;
        }
        if (this.mmoPlayer.isDebugMode()) {
            this.mmoPlayer.getPlayer().sendMessage("Plants processed: " + brokenPlants.size());
        }
        if (xpToReward > 0) {
            Block firstBlock = brokenPlants.stream().findFirst().orElse(null);
            if (firstBlock != null && ExperienceConfig.getInstance().limitXPOnTallPlants() && plantBreakLimits.containsKey(firstBlock.getType().getKey().getKey())) {
                int limit = plantBreakLimits.get(firstBlock.getType().getKey().getKey()) * firstXpReward;
                this.applyXpGain(Math.min(xpToReward, limit), XPGainReason.PVE, XPGainSource.SELF);
            } else {
                this.applyXpGain(xpToReward, XPGainReason.PVE, XPGainSource.SELF);
            }
        }
    }

    public boolean isAgeableMature(Ageable ageable) {
        return ageable.getAge() == ageable.getMaximumAge() && ageable.getAge() != 0;
    }

    public void awardXPForBlockSnapshots(ArrayList<BlockSnapshot> brokenPlants) {
        int xpToReward = 0;
        int blocksGivingXP = 0;
        for (BlockSnapshot blockSnapshot : brokenPlants) {
            BlockState brokenBlockNewState = blockSnapshot.getBlockRef().getState();
            if (brokenBlockNewState.hasMetadata("mcMMO: Double Drops")) {
                brokenBlockNewState.removeMetadata("mcMMO: Double Drops", (Plugin)mcMMO.p);
            }
            if (brokenBlockNewState.getType() != Material.AIR) continue;
            if (mcMMO.getUserBlockTracker().isIneligible(brokenBlockNewState)) {
                mcMMO.getUserBlockTracker().setEligible(brokenBlockNewState);
                continue;
            }
            xpToReward += ExperienceConfig.getInstance().getXp(PrimarySkillType.HERBALISM, blockSnapshot.getOldType());
            ++blocksGivingXP;
        }
        if (this.mmoPlayer.isDebugMode()) {
            this.mmoPlayer.getPlayer().sendMessage("Chorus Plants checked for XP: " + brokenPlants.size());
            this.mmoPlayer.getPlayer().sendMessage("Valid Chorus Plant XP Gains: " + blocksGivingXP);
        }
        if (xpToReward > 0) {
            this.applyXpGain(xpToReward, XPGainReason.PVE, XPGainSource.SELF);
        }
    }

    private HashSet<Block> getBrokenHerbalismBlocks(@NotNull BlockBreakEvent blockBreakEvent) {
        BlockState originBlockState = blockBreakEvent.getBlock().getState();
        Material originBlockMaterial = originBlockState.getType();
        HashSet<Block> blocksBroken = new HashSet<Block>();
        blocksBroken.add(originBlockState.getBlock());
        if (!this.isOneBlockPlant(originBlockMaterial)) {
            this.addBrokenBlocksMultiBlockPlants(originBlockState, blocksBroken);
        }
        return blocksBroken;
    }

    private void addChorusTreeBrokenBlocks(Block currentBlock, Set<Block> traversed) {
        if (!this.isChorusTree(currentBlock.getType())) {
            return;
        }
        if (traversed.size() > 256) {
            return;
        }
        if (!traversed.add(currentBlock)) {
            return;
        }
        for (BlockFace blockFace : new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            this.addChorusTreeBrokenBlocks(currentBlock.getRelative(blockFace, 1), traversed);
        }
    }

    protected void addBrokenBlocksMultiBlockPlants(BlockState brokenBlock, Set<Block> brokenBlocks) {
        if (this.isChorusBranch(brokenBlock.getType())) {
            this.addChorusTreeBrokenBlocks(brokenBlock.getBlock(), brokenBlocks);
        } else if (this.isCactus(brokenBlock.getType())) {
            this.addCactusBlocks(brokenBlock.getBlock(), brokenBlocks);
        } else {
            this.addBlocksBrokenAboveOrBelow(brokenBlock.getBlock(), brokenBlocks, mcMMO.getMaterialMapStore().isMultiBlockHangingPlant(brokenBlock.getType()));
        }
    }

    private void addCactusBlocks(Block currentBlock, Set<Block> traversed) {
        if (!this.isCactus(currentBlock.getType())) {
            return;
        }
        if (traversed.size() > 4) {
            return;
        }
        if (!traversed.add(currentBlock)) {
            return;
        }
        this.addCactusBlocks(currentBlock.getRelative(BlockFace.UP), traversed);
        this.addCactusBlocks(currentBlock.getRelative(BlockFace.DOWN), traversed);
    }

    private boolean isCactus(Material material) {
        return material.getKey().getKey().equalsIgnoreCase(CACTUS_ID) || material.getKey().getKey().equalsIgnoreCase(CACTUS_FLOWER_STR);
    }

    private boolean isChorusBranch(Material blockType) {
        return blockType == Material.CHORUS_PLANT;
    }

    private boolean isChorusTree(Material blockType) {
        return blockType == Material.CHORUS_PLANT || blockType == Material.CHORUS_FLOWER;
    }

    private void addBlocksBrokenAboveOrBelow(Block originBlock, Set<Block> brokenBlocks, boolean below) {
        Block relativeBlock;
        int maxHeight = 512;
        BlockFace relativeFace = below ? BlockFace.DOWN : BlockFace.UP;
        for (int y = 0; y < maxHeight && !this.isOneBlockPlant((relativeBlock = originBlock.getRelative(relativeFace, y)).getType()); ++y) {
            brokenBlocks.add(relativeBlock);
        }
    }

    private boolean isOneBlockPlant(Material material) {
        return !mcMMO.getMaterialMapStore().isMultiBlockPlant(material) && !mcMMO.getMaterialMapStore().isMultiBlockHangingPlant(material);
    }

    private boolean checkDoubleDrop(@NotNull Block block) {
        Objects.requireNonNull(block, "BlockState cannot be null");
        return BlockUtils.checkDoubleDrops(this.mmoPlayer, block, SubSkillType.HERBALISM_DOUBLE_DROPS);
    }

    public boolean processGreenThumbBlocks(BlockState blockState) {
        if (!ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.HERBALISM_GREEN_THUMB, this.mmoPlayer)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE_FAILED, "Herbalism.Ability.GTh.Fail");
            return false;
        }
        return Herbalism.convertGreenTerraBlocks(blockState);
    }

    public boolean processHylianLuck(BlockState blockState) {
        if (!ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.HERBALISM_HYLIAN_LUCK, this.mmoPlayer)) {
            return false;
        }
        String materialConfigString = ConfigStringUtils.getMaterialConfigString(blockState.getBlockData().getMaterial());
        if (!TreasureConfig.getInstance().hylianMap.containsKey(materialConfigString)) {
            return false;
        }
        List<HylianTreasure> treasures = TreasureConfig.getInstance().hylianMap.get(materialConfigString);
        if (treasures.isEmpty()) {
            return false;
        }
        int skillLevel = this.getSkillLevel();
        Location centerOfBlock = Misc.getBlockCenter(blockState);
        for (HylianTreasure treasure : treasures) {
            if (skillLevel < treasure.getDropLevel() || !ProbabilityUtil.isStaticSkillRNGSuccessful(PrimarySkillType.HERBALISM, this.mmoPlayer, treasure.getDropChance())) continue;
            if (!EventUtils.simulateBlockBreak(blockState.getBlock(), this.mmoPlayer.getPlayer())) {
                return false;
            }
            blockState.setType(Material.AIR);
            ItemUtils.spawnItem(this.getPlayer(), centerOfBlock, treasure.getDrop(), ItemSpawnReason.HYLIAN_LUCK_TREASURE);
            NotificationManager.sendPlayerInformation(this.mmoPlayer.getPlayer(), NotificationType.SUBSKILL_MESSAGE, "Herbalism.HylianLuck");
            return true;
        }
        return false;
    }

    public boolean processShroomThumb(BlockState blockState) {
        PlayerInventory playerInventory = this.getPlayer().getInventory();
        if (!playerInventory.contains(Material.BROWN_MUSHROOM, 1)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.REQUIREMENTS_NOT_MET, "Skills.NeedMore", StringUtils.getPrettyMaterialString(Material.BROWN_MUSHROOM));
            return false;
        }
        if (!playerInventory.contains(Material.RED_MUSHROOM, 1)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.REQUIREMENTS_NOT_MET, "Skills.NeedMore", StringUtils.getPrettyMaterialString(Material.RED_MUSHROOM));
            return false;
        }
        playerInventory.removeItem(new ItemStack[]{new ItemStack(Material.BROWN_MUSHROOM)});
        playerInventory.removeItem(new ItemStack[]{new ItemStack(Material.RED_MUSHROOM)});
        if (!ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.HERBALISM_SHROOM_THUMB, this.mmoPlayer)) {
            NotificationManager.sendPlayerInformation(this.getPlayer(), NotificationType.SUBSKILL_MESSAGE_FAILED, "Herbalism.Ability.ShroomThumb.Fail");
            return false;
        }
        return Herbalism.convertShroomThumb(blockState);
    }

    private void startReplantTask(int desiredCropAge, BlockBreakEvent blockBreakEvent, BlockState cropState, boolean isImmature) {
        mcMMO.p.getFoliaLib().getScheduler().runAtLocationLater(blockBreakEvent.getBlock().getLocation(), (Consumer)new DelayedCropReplant(blockBreakEvent, cropState, desiredCropAge, isImmature), 20L);
        blockBreakEvent.getBlock().setMetadata("mcMMO: Recently Replanted", (MetadataValue)new RecentlyReplantedCropMeta((Plugin)mcMMO.p, true));
    }

    private boolean processGreenThumbPlants(@NotNull BlockState blockState, @NotNull BlockBreakEvent blockBreakEvent, boolean greenTerra) {
        Material replantMaterial;
        if (!ItemUtils.isHoe(blockBreakEvent.getPlayer().getInventory().getItemInMainHand()) && !ItemUtils.isAxe(blockBreakEvent.getPlayer().getInventory().getItemInMainHand())) {
            return false;
        }
        BlockData blockData = blockState.getBlockData();
        if (!(blockData instanceof Ageable)) {
            return false;
        }
        Ageable ageable = (Ageable)blockData;
        Player player = this.getPlayer();
        switch (blockState.getType().getKey().getKey().toLowerCase(Locale.ENGLISH)) {
            case "carrots": {
                replantMaterial = Material.matchMaterial((String)"CARROT");
                break;
            }
            case "wheat": {
                replantMaterial = Material.matchMaterial((String)"WHEAT_SEEDS");
                break;
            }
            case "nether_wart": {
                replantMaterial = Material.getMaterial((String)"NETHER_WART");
                break;
            }
            case "potatoes": {
                replantMaterial = Material.matchMaterial((String)"POTATO");
                break;
            }
            case "beetroots": {
                replantMaterial = Material.matchMaterial((String)"BEETROOT_SEEDS");
                break;
            }
            case "cocoa": {
                replantMaterial = Material.matchMaterial((String)"COCOA_BEANS");
                break;
            }
            case "torchflower": {
                replantMaterial = Material.matchMaterial((String)"TORCHFLOWER_SEEDS");
                break;
            }
            default: {
                return false;
            }
        }
        if (replantMaterial == null) {
            return false;
        }
        if (ItemUtils.isAxe(blockBreakEvent.getPlayer().getInventory().getItemInMainHand()) && blockState.getType() != Material.COCOA) {
            return false;
        }
        if (!greenTerra && !ProbabilityUtil.isSkillRNGSuccessful(SubSkillType.HERBALISM_GREEN_THUMB, this.mmoPlayer)) {
            return false;
        }
        if (!ItemUtils.hasItemIncludingOffHand(player, replantMaterial)) {
            return false;
        }
        if (EventUtils.callSubSkillBlockEvent(player, SubSkillType.HERBALISM_GREEN_THUMB, blockState.getBlock()).isCancelled()) {
            return false;
        }
        if (!this.processGrowingPlants(blockState, ageable, blockBreakEvent, greenTerra)) {
            return false;
        }
        ItemUtils.removeItemIncludingOffHand(player, replantMaterial, 1);
        SoundManager.sendSound(player, player.getLocation(), SoundType.ITEM_CONSUMED);
        return true;
    }

    private boolean processGrowingPlants(BlockState blockState, Ageable ageable, BlockBreakEvent blockBreakEvent, boolean greenTerra) {
        int finalAge;
        if (this.isBizarreAgeable((BlockData)ageable)) {
            return false;
        }
        int greenThumbStage = this.getGreenThumbStage(greenTerra);
        if (!this.isAgeableMature(ageable)) {
            this.startReplantTask(0, blockBreakEvent, blockState, true);
            blockBreakEvent.setDropItems(false);
            return true;
        }
        switch (blockState.getType().getKey().getKey()) {
            case "potatoes": 
            case "carrots": 
            case "wheat": {
                finalAge = this.getGreenThumbStage(greenTerra);
                break;
            }
            case "beetroots": 
            case "nether_wart": {
                if (greenTerra || greenThumbStage > 2) {
                    finalAge = 2;
                    break;
                }
                if (greenThumbStage == 2) {
                    finalAge = 1;
                    break;
                }
                finalAge = 0;
                break;
            }
            case "cocoa": {
                if (this.getGreenThumbStage(greenTerra) >= 2) {
                    finalAge = 1;
                    break;
                }
                finalAge = 0;
                break;
            }
            default: {
                return false;
            }
        }
        this.startReplantTask(finalAge, blockBreakEvent, blockState, false);
        return true;
    }

    private int getGreenThumbStage(boolean greenTerraActive) {
        if (greenTerraActive) {
            return Math.min(RankUtils.getHighestRank(SubSkillType.HERBALISM_GREEN_THUMB), RankUtils.getRank(this.getPlayer(), SubSkillType.HERBALISM_GREEN_THUMB) + 1);
        }
        return RankUtils.getRank(this.getPlayer(), SubSkillType.HERBALISM_GREEN_THUMB);
    }

    static {
        plantBreakLimits.put(CACTUS_ID, 3);
        plantBreakLimits.put(BAMBOO_ID, 20);
        plantBreakLimits.put(SUGAR_CANE_ID, 3);
        plantBreakLimits.put(KELP_ID, 26);
        plantBreakLimits.put(KELP_PLANT_ID, 26);
        plantBreakLimits.put(CHORUS_PLANT_ID, 22);
    }

    private class CheckBushAge
    extends CancellableRunnable {
        @NotNull
        Block block;
        @NotNull
        McMMOPlayer mmoPlayer;
        int xpReward;

        public CheckBushAge(@NotNull Block block, McMMOPlayer mmoPlayer, int xpReward) {
            this.block = block;
            this.mmoPlayer = mmoPlayer;
            this.xpReward = xpReward;
        }

        @Override
        public void run() {
            Ageable ageable;
            BlockData blockData;
            BlockState blockState = this.block.getState();
            if (blockState.getType().toString().equalsIgnoreCase(HerbalismManager.SWEET_BERRY_BUSH_ID) && (blockData = blockState.getBlockData()) instanceof Ageable && (ageable = (Ageable)blockData).getAge() <= 1) {
                HerbalismManager.this.applyXpGain(this.xpReward, XPGainReason.PVE, XPGainSource.SELF);
            }
        }
    }
}

